package iwocs;

import static iwocs.graphs.GraphIO.exportHashMapDistribution;
import static iwocs.graphs.GraphIO.getNerdsGraph;
import static iwocs.graphs.GraphUtils.calculateDistancesDistributionFromSample;
import static iwocs.graphs.GraphUtils.calculateMeanDistanceFromSample;

import org.graphstream.algorithm.Toolkit;
import org.graphstream.graph.Graph;

/**
 * App which purpose is to experiment on a real life scaled interaction network
 * (scientific collaboration).
 */
public class App {
  public static void main(String[] args) {
    Graph g = getNerdsGraph();

    int nb_nodes = g.getNodeCount();
    int nb_links = g.getEdgeCount();

    System.out.format("N: %d\nL: %d\n<k>: %.3f\n<C>: %.3f\nConnected: %b\n<d>: %.3f\n",
      nb_nodes,
      nb_links,
      Toolkit.averageDegree(g),
      Toolkit.averageClusteringCoefficient(g),
      Toolkit.isConnected(g),
      calculateMeanDistanceFromSample(g, 1000)
    );

    exportHashMapDistribution(calculateDistancesDistributionFromSample(g, 1000), "distance_distrib");
  }

  
}