package edu.mermet.buttonup.modele;

import static org.junit.Assert.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.junit.Before;
import org.junit.Test;

public class PlateauTest {
	private Plateau instance;
	
    @Before
    public void setUp() {
    	instance = creerPlateau("<[blanc]/[blanc]/[rouge]/[noir]/[rouge]/"+
                "[blanc]/[rouge]/[noir]/[noir]>", Bouton.noir);
    }
    
    private static Plateau creerPlateau(String pattern, Bouton joueur) {
        ArrayList<Pile> plateau = new ArrayList<Pile>();
        String aDecomposer = pattern.substring(1, pattern.length() - 1);
        String[] piles = aDecomposer.split("/");
        for (String pile : piles) {
            pile = pile.substring(1, pile.length() - 1);
            String[] boutons = pile.split(",");
            Pile p = new Pile();
            for (String bouton : boutons) {
                switch (bouton) {
                    case "blanc":
                        p.empiler(Bouton.blanc);
                        break;
                    case "rouge":
                        p.empiler(Bouton.rouge);
                        break;
                    case "noir":
                        p.empiler(Bouton.noir);
                        break;
                }
            }
            plateau.add(p);
        }
        return new Plateau(plateau, joueur);
    }

    private static boolean estPermutation(final List<Pile> pile1,
                                          final List<Pile> pile2) {
        return pile1.containsAll(pile2) && pile2.containsAll(pile1);
    }


    @Test
    public void testToString() {
        System.out.println("toString  Plateau");
        String expResult = "<[blanc]/[blanc]/[rouge]/[noir]/[rouge]/"+
                           "[blanc]/[rouge]/[noir]/[noir]>";
        String result = instance.toString();
        assertEquals(expResult, result);
    }

    @Test
    public void testEquals() {
        System.out.println("equals Plateau");
        Plateau instance2 = creerPlateau("<[blanc]/[blanc]/[rouge]/[noir]/[rouge]/"
                + "[blanc]/[rouge]/[noir]/[noir]>", Bouton.noir);
        assertEquals("plateaux égaux", instance, instance2);
        Plateau instance3 = creerPlateau("<[blanc]/[blanc]/[rouge]/[noir]/[rouge]/"
                + "[blanc]/[rouge]/[noir]/[noir]>", Bouton.rouge);
        assertFalse("plateaux différents de par le joueur courant",
                    instance.equals(instance3));
        Plateau instance4 = creerPlateau("<[rouge]/[blanc]/[rouge]/[noir]/[blanc]/"
                + "[blanc]/[rouge]/[noir]/[noir]>", Bouton.noir);;
        assertFalse("plateaux différents de par la composition",
                    instance.equals(instance4));
    }

    @Test
    public void testCreationPlateau() {
        System.out.println("gnration alatoire du plateau");
        ArrayList<Pile> liste = new ArrayList<Pile>();
        liste.add(new Pile(Bouton.blanc));
        liste.add(new Pile(Bouton.blanc));
        liste.add(new Pile(Bouton.blanc));
        liste.add(new Pile(Bouton.rouge));
        liste.add(new Pile(Bouton.rouge));
        liste.add(new Pile(Bouton.rouge));
        liste.add(new Pile(Bouton.noir));
        liste.add(new Pile(Bouton.noir));
        liste.add(new Pile(Bouton.noir));

        for (int i = 0; i < 20; i++) {
            Plateau instance2 = new Plateau();
            assertTrue("permutation correcte",
                    estPermutation(instance.getPlateau(), instance2.getPlateau()));
        }
    }

    @Test
    public void testCreationPremierJoueur() {
        System.out.println("generation premier joueur");
        boolean estNoir;
        boolean estRouge;
        boolean estAutre;
        estNoir = false;
        estRouge = false;
        estAutre = false;
        Plateau instance;
        for (int i = 0; i < 100 && !estAutre; i++) {
            instance = new Plateau();
            Bouton joueur = instance.getJoueurCourant();
            switch(joueur) {
                case noir:
                    estNoir = true;
                    break;
                case rouge:
                    estRouge = true;
                    break;
                default:
                    estAutre = true;
            }
        }
        assertTrue("au moins un noir", estNoir);
        assertTrue("au moins un rouge", estRouge);
        assertFalse("que du noir ou du rouge", estAutre);
    }
    
    @Test(expected = ButtonUpException.class)
    public void testSemerErreur1() throws ButtonUpException {
        System.out.println("semer Plateau hors rang 1");
        instance.semer(-1);
    }

    @Test(expected = ButtonUpException.class)
    public void testSemerErreur2() throws ButtonUpException {
        System.out.println("semer Plateau hors rang 2");
        instance.semer(10);
    }

    @Test(expected = ButtonUpException.class)
    public void testSemerErreur3() throws ButtonUpException {
        System.out.println("semer Plateau pile sans Blanc");
        instance.semer(3);
    }

    @Test
    public void testSemerCorrect1() throws ButtonUpException {
        System.out.println("semer Plateau pile Blanc");
        instance.semer(1);
        String expResult = "<[blanc,blanc]/[rouge]/[noir]/[rouge]/"
                           + "[blanc]/[rouge]/[noir]/[noir]>";
        assertEquals("premier semis", expResult, instance.toString());

        instance.semer(5);
        expResult = "<[blanc,blanc]/[rouge]/[noir]/[rouge]/"
                           + "[rouge,blanc]/[noir]/[noir]>";
        assertEquals("deuxieme semis", expResult, instance.toString());

        instance.semer(5);
        expResult = "<[blanc,blanc]/[rouge]/[noir]/[rouge]/"
                           + "[noir,rouge]/[noir,blanc]>";
        assertEquals("troisieme semis", expResult, instance.toString());
    }

    @Test
    public void testSemerCorrect2() throws ButtonUpException {
        System.out.println("semer Plateau pile Blanc avec debordement");
        instance.semer(1);
        instance.semer(5);
        instance.semer(5);
        instance.semer(6);
        String expResult = "<[blanc,blanc,noir]/[rouge,blanc]/[noir]/[rouge]/"
                           + "[noir,rouge]>";
        assertEquals("quatrieme semis", expResult, instance.toString());
        instance.semer(2);
        expResult = "<[blanc,blanc,noir]/[noir,rouge]/[rouge,blanc]/"
                           + "[noir,rouge]>";
        assertEquals("cinquieme semis", expResult, instance.toString());
        instance.semer(3);
        expResult = "<[blanc,blanc,noir,blanc]/[noir,rouge]/"
                           + "[noir,rouge,rouge]>";
        assertEquals("sixieme semis", expResult, instance.toString());
    }

    @Test
    public void testSemerCorrect3() throws ButtonUpException {
        System.out.println("semer Plateau pile Blanc avec 'trop' de pions");
        instance.semer(1);
        instance.semer(5);
        instance.semer(5);
        instance.semer(6);
        instance.semer(2);
        instance.semer(3);
        instance.semer(1);
        String expResult = "<[noir,rouge,blanc]/"
                           + "[noir,rouge,rouge,blanc,noir,blanc]>";
        assertEquals("septieme semis", expResult, instance.toString());
    }
    
    @Test
    public void testChangementJoueur() throws ButtonUpException {
        System.out.println("coup impliquant changement de joueur N->R");
        instance.semer(2);
        assertEquals("joueur a changé",Bouton.rouge,instance.getJoueurCourant());
    }

    @Test
    public void testChangementJoueur2() throws ButtonUpException {
        System.out.println("coup impliquant changement de joueur R->N");
        instance.setJoueurCourant(Bouton.rouge);
        instance.semer(2);
        assertEquals("joueur a changé",Bouton.noir,instance.getJoueurCourant());
    }

    @Test
    public void testChangementJoueur3() throws ButtonUpException {
        System.out.println("coup impliquant (depot en masse)");
        Plateau instance = creerPlateau("<[blanc,blanc,noir,rouge,noir]/"
                + "[noir,rouge,rouge,blanc]>", Bouton.noir);
        instance.semer(1);
        assertEquals("joueur a changé",Bouton.rouge,instance.getJoueurCourant());
    }

    @Test
    public void testChangementJoueur4() throws ButtonUpException {
        System.out.println("coup sans changement de joueur N->N");
        instance.semer(1);
        assertEquals("joueur non changé",Bouton.noir,instance.getJoueurCourant());
    }

    @Test
    public void testEstTermineVrai() {
    	System.out.println("partie rellemment termine");
        Plateau instance = creerPlateau("<[blanc,blanc,rouge,noir,rouge,"
                + "blanc,rouge,noir,noir]>", Bouton.noir);
        assertTrue("partie termine",instance.estTermine());
    }

    @Test
    public void testEstTermineFaux1() {
    	System.out.println("partie non termine 1");
        assertFalse("partie termine",instance.estTermine());
    }

    @Test
    public void testEstTermineFaux2() {
    	System.out.println("partie non termine 2");
        Plateau instance = creerPlateau("<[blanc,blanc,rouge,noir,rouge]/"
                + "[blanc,rouge,noir,noir]>", Bouton.rouge);
        assertFalse("partie termine",instance.estTermine());
    }
    
    @Test(expected=ButtonUpException.class)
    public void testCalculScoreException() throws ButtonUpException {
    	System.out.println("calcul score avant fin");
        Plateau instance = creerPlateau("<[blanc,blanc,rouge,noir,rouge]/"
                + "[blanc,rouge,noir,noir]>", Bouton.noir);
        instance.calculScore();
    }

    @Test(expected=ButtonUpException.class)
    public void testGetGagnantException() throws ButtonUpException {
    	System.out.println("calcul score avant fin");
        Plateau instance = creerPlateau("<[blanc,blanc,rouge,noir,rouge]/"
                + "[blanc,rouge,noir,noir]>", Bouton.noir);
        instance.getGagnant();
    }
    @Test
    public void testCalculScoreEtGetGagnantNoirGagne1() throws ButtonUpException {
    	System.out.println("calcul score noir gagne");
        Plateau instance = creerPlateau("<[blanc,blanc,rouge,noir,rouge,"
                + "blanc,rouge,noir,noir]>", Bouton.noir);
        int scoreAttendu = 6;
        Bouton joueurAttendu = Bouton.noir;
        assertEquals("score",scoreAttendu,instance.calculScore());
        assertEquals("gagnant",joueurAttendu,instance.getGagnant());
    }

    @Test
    public void testCalculScoreEtGetGagnantNoirGagne2() throws ButtonUpException {
    	System.out.println("calcul score noir gagne bis");
        Plateau instance = creerPlateau("<[noir,rouge,rouge,blanc,rouge,"
                + "blanc,blanc,noir,noir]>", Bouton.noir);
        int scoreAttendu = 8;
        Bouton joueurAttendu = Bouton.noir;
        assertEquals("score",scoreAttendu,instance.calculScore());
        assertEquals("gagnant",joueurAttendu,instance.getGagnant());
    }

    @Test
    public void testCalculScoreEtGetGagnantBlanc() throws ButtonUpException {
    	System.out.println("calcul score blanc gagne");
        Plateau instance = creerPlateau("<[noir,noir,noir,blanc,rouge,"
                + "blanc,blanc,rouge,rouge]>", Bouton.noir);
        int scoreAttendu = -16;
        Bouton joueurAttendu = Bouton.rouge;
        assertEquals("score",scoreAttendu,instance.calculScore());
        assertEquals("gagnant",joueurAttendu,instance.getGagnant());
    }

    @Test
    public void testCalculScoreEtGetGagnantNul() throws ButtonUpException {
    	System.out.println("calcul score egalite");
        Plateau instance = creerPlateau("<[noir,rouge,noir,rouge,blanc,"
                + "blanc,rouge,blanc,noir]>", Bouton.noir);
        int scoreAttendu = 0;
        Bouton joueurAttendu = Bouton.blanc;
        assertEquals("score",scoreAttendu,instance.calculScore());
        assertEquals("gagnant",joueurAttendu,instance.getGagnant());
    }
    
    @Test(expected=ButtonUpException.class)
    public void testSetJoueurCourantException() throws ButtonUpException {
    	Plateau instance = new Plateau();
    	instance.setJoueurCourant(Bouton.blanc);
    }

    @Test
    public void testSetJoueurCourant() throws ButtonUpException {
    	Plateau instance = new Plateau();
    	Bouton attendu;
    	for (int i = 0 ; i < 10; i++) {
    		Random rand = new Random();
    		if (rand.nextBoolean()) {
    			attendu = Bouton.noir;
    		} else {
    			attendu = Bouton.rouge;
    		}
    		instance.setJoueurCourant(attendu);
    		assertEquals(attendu, instance.getJoueurCourant());
    	}
    }
}
