package edu.mermet.buttonup.modele;

import static org.junit.Assert.*;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.junit.Before;
import org.junit.Test;


public class PartieTest {
	private Partie partie;

	@Before
	public void setUp() {
		partie = new Partie();
	}
	
	@Test
	public void testInit() {
		System.out.println("Au début, les scores sont à zéro");
		int scoreGagnantAttendu = 0;
		int scorePerdantAttendu = 0;
		assertEquals(scoreGagnantAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
	}
	
	@Test
	public void testAjouterScorePositifSeul() {
		System.out.println("Noir gagne de 2 puis 3 puis 8");
		int scoreAttendu = 0;
		int scorePerdantAttendu = 0;
		Bouton gagnantAttendu = Bouton.noir;
		partie.ajouterScore(2);
		scoreAttendu += 2;
		assertEquals(scoreAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
		partie.ajouterScore(3);
		scoreAttendu += 3;
		assertEquals(scoreAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
		partie.ajouterScore(8);
		scoreAttendu += 8;
		assertEquals(scoreAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
	}

	@Test
	public void testAjouterScoreNegatifSeul() {
		System.out.println("Rouge gagne de 1 puis 4 puis 7");
		int scoreAttendu = 0;
		int scorePerdantAttendu = 0;
		Bouton gagnantAttendu = Bouton.rouge;
		partie.ajouterScore(-1);
		scoreAttendu += 1;
		assertEquals(scoreAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
		partie.ajouterScore(-4);
		scoreAttendu += 4;
		assertEquals(scoreAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
		partie.ajouterScore(-7);
		scoreAttendu += 7;
		assertEquals(scoreAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
	}

	@Test
	public void testAjouterScoreNegatifEtPositifs() {
		System.out.println("Rouge gagne de 2 puis 0 puis Noir de 4 puis rouge de 5 puis Noir de 1");
		int scoreGagnantAttendu = 0;
		int scorePerdantAttendu = 0;
		Bouton gagnantAttendu = Bouton.rouge;
		partie.ajouterScore(-2);
		scoreGagnantAttendu = 2;
		scorePerdantAttendu = 0;
		assertEquals(scoreGagnantAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
		partie.ajouterScore(0);
		scoreGagnantAttendu = 2;
		scorePerdantAttendu = 0;
		assertEquals(scoreGagnantAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
		partie.ajouterScore(4);
		scoreGagnantAttendu = 4;
		scorePerdantAttendu = 2;
		gagnantAttendu = Bouton.noir;
		assertEquals(scoreGagnantAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
		partie.ajouterScore(-5);
		scoreGagnantAttendu = 7;
		scorePerdantAttendu = 4;
		gagnantAttendu = Bouton.rouge;
		assertEquals(scoreGagnantAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
		partie.ajouterScore(1);
		scoreGagnantAttendu = 7;
		scorePerdantAttendu = 5;
		gagnantAttendu = Bouton.rouge;
		assertEquals(scoreGagnantAttendu, partie.scoreGagnant());
		assertEquals(scorePerdantAttendu, partie.scorePerdant());
		assertEquals(gagnantAttendu, partie.joueurGagnant());
	}
	
	@Test
	public void testEstTermineeNoirGagnant() {
		System.out.println("test de estTermine quand Noir gagne");
		assertFalse(partie.estTerminee());
		partie.ajouterScore(5);
		assertFalse(partie.estTerminee());
		partie.ajouterScore(-5);
		assertFalse(partie.estTerminee());
		partie.ajouterScore(10);
		assertTrue(partie.estTerminee());
	}

	@Test
	public void testEstTermineeRougeGagnant() {
		System.out.println("test de estTermine quand Rouge gagne");
		assertFalse(partie.estTerminee());
		partie.ajouterScore(-4);
		assertFalse(partie.estTerminee());
		partie.ajouterScore(8);
		assertFalse(partie.estTerminee());
		partie.ajouterScore(-20);
		assertTrue(partie.estTerminee());
	}
	
	@Test
	public void testJoueurGagnant() {
		System.out.println("test joueur gagnant");
		Bouton attendu = Bouton.noir;
		partie.ajouterScore(4);
		assertEquals(attendu,partie.joueurGagnant());
		attendu = Bouton.noir;
		partie.ajouterScore(2);
		assertEquals(attendu,partie.joueurGagnant());
		attendu = Bouton.rouge;
		partie.ajouterScore(-7);
		assertEquals(attendu,partie.joueurGagnant());
		attendu = Bouton.rouge;
		partie.ajouterScore(-1);
		assertEquals(attendu,partie.joueurGagnant());
		attendu = Bouton.blanc;
		partie.ajouterScore(2);
		assertEquals(attendu,partie.joueurGagnant());
		attendu = Bouton.blanc;
		partie.ajouterScore(0);
		assertEquals(attendu,partie.joueurGagnant());
		attendu = Bouton.noir;
		partie.ajouterScore(10);
		assertEquals(attendu,partie.joueurGagnant());
	}

	@Test
	public void testJoueurPerdant() {
		System.out.println("test joueur perdant");
		Bouton attendu = Bouton.rouge;
		partie.ajouterScore(4);
		assertEquals(attendu,partie.joueurPerdant());
		attendu = Bouton.rouge;
		partie.ajouterScore(2);
		assertEquals(attendu,partie.joueurPerdant());
		attendu = Bouton.noir;
		partie.ajouterScore(-7);
		assertEquals(attendu,partie.joueurPerdant());
		attendu = Bouton.noir;
		partie.ajouterScore(-1);
		assertEquals(attendu,partie.joueurPerdant());
		attendu = Bouton.blanc;
		partie.ajouterScore(2);
		assertEquals(attendu,partie.joueurPerdant());
		attendu = Bouton.blanc;
		partie.ajouterScore(0);
		assertEquals(attendu,partie.joueurPerdant());
		attendu = Bouton.rouge;
		partie.ajouterScore(10);
		assertEquals(attendu,partie.joueurPerdant());
	}
	
	class EcouteurTest implements PropertyChangeListener {
		private int valeur = 1000;
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			valeur = (Integer) evt.getNewValue();
		}
		public int getValeur() {
			return valeur;
		}
		
	}

	@Test
	public void testEcouteurChangementNoir() {
		System.out.println("test ecouteur noir");
		EcouteurTest ecouteurNoir = new EcouteurTest();
		EcouteurTest ecouteurRouge = new EcouteurTest();
		partie.addPropertyChangeListener("noir", ecouteurNoir);
		partie.addPropertyChangeListener("rouge", ecouteurRouge);
		int attenduNoir = 5;
		int attenduRouge = 1000;
		partie.ajouterScore(5);
		try {
			Thread.sleep(100);
		} catch (InterruptedException e) {}
		assertEquals(attenduNoir, ecouteurNoir.getValeur());
		assertEquals(attenduRouge, ecouteurRouge.getValeur());
	}

	@Test
	public void testEcouteurChangementRouge() {
		System.out.println("test ecouteur rouge");
		EcouteurTest ecouteurRouge = new EcouteurTest();
		EcouteurTest ecouteurNoir = new EcouteurTest();
		partie.addPropertyChangeListener("rouge", ecouteurRouge);
		partie.addPropertyChangeListener("noir", ecouteurNoir);
		int attenduRouge = 5;
		int attenduNoir = 1000;
		partie.ajouterScore(-5);
		try {
			Thread.sleep(100);
		} catch (InterruptedException e) {}
		assertEquals(attenduRouge, ecouteurRouge.getValeur());
		assertEquals(attenduNoir, ecouteurNoir.getValeur());
	}

}
