package edu.mermet.buttonup.modele;

import java.util.ArrayList;
import java.util.List;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;


public class Pile implements IPile {
    private List<Bouton> pile;
	private PropertyChangeSupport supportChangement;

    public Pile() {
        pile = new ArrayList<Bouton>();
        supportChangement = new PropertyChangeSupport(this);
    }
    
    public Pile(Bouton b) {
    	this();
        pile.add(b);
    }

	public void addPropertyChangeListener(String prop, PropertyChangeListener pcl) {
		supportChangement.addPropertyChangeListener(prop,pcl);
	}
	
	public void removePropertyChangeListener(String prop, PropertyChangeListener pcl) {
		supportChangement.removePropertyChangeListener(prop,pcl);
	}

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (Bouton b: pile) {
            sb.append(b.toString());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length()-1);
        sb.append("]");
        return sb.toString();
    }
    
    public void empiler(Bouton b) {
        pile.add(b);fire();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (this.pile != null ? this.pile.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Pile other = (Pile) obj;
        if (this.pile != other.pile && (this.pile == null || !this.pile.equals(other.pile))) {
            return false;
        }
        return true;
    }

    public boolean contientBlanc() {
        boolean trouve = false;
        for (Bouton bouton : pile) {
            if (bouton.equals(Bouton.blanc)) {
                trouve = true;
                break;
            }
        }
        return trouve;
    }

    Bouton defiler() {
        Bouton base;
        base = pile.remove(0);
        fire();
        return base;
    }
    
    boolean nonVide() {
        return !pile.isEmpty();
    }
    
    void ajouter(Pile autrePile) {
        pile.addAll(autrePile.pile);
        fire();
    }
    
    Bouton sommet() {
        return pile.get(pile.size()-1);
    }
    
    public List<Bouton> getList() {
    	return pile;
    }
    
    private void fire() {
    	supportChangement.firePropertyChange("pile",null,pile);
    }
}
