package edu.mermet.buttonup.modele;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;


public class Partie implements IPartie {
	public final static int MAX = 15;
	private int scoreNoir;
	private int scoreRouge;
	private PropertyChangeSupport supportChangement;
	
	public Partie() {
		scoreNoir = 0;
		scoreRouge = 0;
		supportChangement = new PropertyChangeSupport(this);
	}
	
	public void addPropertyChangeListener(String prop, PropertyChangeListener pcl) {
		supportChangement.addPropertyChangeListener(prop,pcl);
	}
	
	public void removePropertyChangeListener(String prop, PropertyChangeListener pcl) {
		supportChangement.removePropertyChangeListener(prop,pcl);
	}
	
	public boolean estTerminee() {
		return scoreNoir >= MAX || scoreRouge >= MAX;
	}
	
	public Bouton joueurGagnant() {
		Bouton gagnant = Bouton.blanc;
		if (scoreNoir > scoreRouge) {
			gagnant = Bouton.noir;
		}
		else if (scoreRouge > scoreNoir) {
			gagnant = Bouton.rouge;
		}
		return gagnant;
	}
	
	public Bouton joueurPerdant() {
		Bouton perdant = Bouton.blanc;
		if (scoreNoir < scoreRouge) {
			perdant = Bouton.noir;
		}
		else if (scoreRouge < scoreNoir) {
			perdant = Bouton.rouge;
		}
		return perdant;
	}

	public int scoreGagnant() {
		return Math.max(scoreNoir, scoreRouge);
	}
	
	public int scorePerdant() {
		return Math.min(scoreNoir, scoreRouge);
	}

	public void ajouterScore(int score) {
		if (score > 0) {
			scoreNoir += score;
			supportChangement.firePropertyChange("noir", scoreNoir-score, scoreNoir);
		}
		else {
			scoreRouge -= score;
			supportChangement.firePropertyChange("rouge", scoreRouge+score, scoreRouge);
		}
	}	
}
