package edu.mermet.buttonup.ihm.vues;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JComponent;

import edu.mermet.buttonup.modele.Bouton;
import edu.mermet.buttonup.modele.Pile;

public class PileVue extends JComponent{
	private Pile pile; 
	private int numPile;
	
	public PileVue(Pile pile, int num) {
	    super();
	    this.pile = pile;
	    this.numPile = num;
	    setPreferredSize(new Dimension(50, 100));

	 }
	public void paint(Graphics g) {
	    Color col;
	    int x=3, y=100-3;
	    
	    for (int i = 0; i < pile.getList().size(); i++ )
	    {
	      y -= 10;
	      col = Color.BLACK;
	      g.setColor(col);
	      g.drawRect(x, y, 44, 10);
	      if (pile.getList().get(i).equals(Bouton.blanc) ) {
	    	  col = Color.WHITE;
	      }
	      else if (pile.getList().get(i).equals(Bouton.rouge)) {
	    	  col = Color.RED;
	      }
	      g.setColor(col);
	      g.fillRect(x+1, y-1, 42, 8);
	    }
	  }

	 public int getNumPile() {
	    return numPile;
	 }

	 public Pile getPile() {
	    return pile;
	 }

	 public int getWidth() {
	    return 50;
	 }
	
	  public int getHeight() {
	    return 100;
	  }
	
	 public Dimension getPrefferedSize() {
	    return new Dimension(50, 100);
	 }
	

}
