package edu.mermet.buttonup.ihm.vues;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

import edu.mermet.buttonup.modele.Partie;

public class PartieVue extends JPanel implements PropertyChangeListener {
    private Partie partie;
    private JLabel rouge, noir;

    public PartieVue(Partie partie) {
        this.partie = partie;
        partie.addPropertyChangeListener("noir", this);
        partie.addPropertyChangeListener("rouge", this);
        init();
        setVisible(true);
    }

    private void init() {
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        noir = new JLabel("0");
        noir.setFont(noir.getFont().deriveFont(18.0f));
        add(noir);
        add(Box.createHorizontalGlue());
        rouge = new JLabel("0");
        rouge.setFont(rouge.getFont().deriveFont(18.0f));
        rouge.setForeground(Color.RED);
        add(rouge);
    }

    public void propertyChange(PropertyChangeEvent e) {
        int newValue = (int) e.getNewValue();
             if (e.getPropertyName().equals("noir" )) noir .setText("" + newValue);
        else if (e.getPropertyName().equals("rouge")) rouge.setText("" + newValue);
    }
}