package edu.mermet.buttonup.ihm.vues;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;


import edu.mermet.buttonup.modele.*;

public class JeuVue extends JPanel {
	private static enum Statut {
		DEPART {Statut precedent() {return DEPART;}},
		ARRIVEE {Statut precedent() {return DEPART;}};
		abstract Statut precedent();
	}
	private Plateau plateau;
	private Partie partie;
	private PlateauVue vueDuPlateau;
	private JButton annuler;
	private JButton valider;
	private JLabel choix;
	private Statut etat;
	private int numPile;
	private JPanel panelEtatCourant;
	private JPanel panneauHaut;
	private JLabel joueurCourant;
	
	public JeuVue() {
		plateau = new Plateau();
		partie = new Partie();
		this.setLayout(new BorderLayout());
		vueDuPlateau = new PlateauVue(plateau);
		vueDuPlateau.addPropertyChangeListener("selection",new VuePlateauListener());
		add(vueDuPlateau, BorderLayout.CENTER);
		annuler = new JButton(new ActionAnnuler());
		valider = new JButton(new ActionValider());
		JPanel bas = new JPanel();
		bas.add(annuler);
		bas.add(valider);
		add(bas,BorderLayout.SOUTH);
		annuler.setEnabled(false);
		valider.setEnabled(false);
		
		panneauHaut = new JPanel();
		panneauHaut.setLayout(new BoxLayout(panneauHaut,BoxLayout.Y_AXIS));
		
		panneauHaut.add(new PartieVue(partie));
		
		choix = new JLabel("    ");
		panelEtatCourant = new JPanel();
		panelEtatCourant.setLayout(new BoxLayout(panelEtatCourant,BoxLayout.X_AXIS));
		panelEtatCourant.add(choix);
		panelEtatCourant.add(Box.createHorizontalGlue());
		panelEtatCourant.add(new JLabel("Joueur courant :"));
		joueurCourant = new JLabel(plateau.getJoueurCourant().toString());
		panelEtatCourant.add(joueurCourant);
		panneauHaut.add(panelEtatCourant);
		add(panneauHaut, BorderLayout.NORTH);
		
		etat = Statut.DEPART;
		numPile = 0;
	}
	
	void majChoix() {
		StringBuilder retour = new StringBuilder(" ");
		if (!etat.equals(Statut.DEPART)) {
			retour.append(numPile);
		}
		choix.setVisible(false);
		choix.setText(retour.toString());
		choix.setVisible(true);
	}
	
	class ActionAnnuler extends AbstractAction {
		public ActionAnnuler() {
			super("Annuler");
		}
		
		public void actionPerformed(ActionEvent ae) {
			etat = etat.precedent();
			annuler.setEnabled(false);
			valider.setEnabled(false);
			majChoix();
		}
	}

	class ActionValider extends AbstractAction {
		public ActionValider() {
			super("Valider");
		}
		public void actionPerformed(ActionEvent ae) {
			System.out.println("on valide" + choix.getText());
			try {
				annuler.setEnabled(false);
				valider.setEnabled(false);
				plateau.semer(numPile);
				joueurCourant.setText(plateau.getJoueurCourant().toString());
			}
			catch(ButtonUpException bue) {
				System.err.println("Ne doit jamais arriver");
			}
			vueDuPlateau.configurer();
			updateUI();
			if (plateau.estTermine()) {
				mancheTerminee();
			}
		}
	}
	
	public void mancheTerminee() {
		try {
			int score = plateau.calculScore();
			partie.ajouterScore(score);
		}
		catch(ButtonUpException bue) {
			System.out.println("Cette exception ne doit jamais se produire !");
			System.exit(1);
		}
		if (partie.estTerminee()) {
			int scoreGagnant = partie.scoreGagnant();
			int scorePerdant = partie.scorePerdant();
			String message;
			if (scoreGagnant != scorePerdant) {
				message = "Le joueur " + partie.joueurGagnant() + " a gagné";
				message += " par " + scoreGagnant + " à " + scorePerdant + "!";
			}
			else {
				message = "Match Nul !";
			}
			JOptionPane.showMessageDialog(JeuVue.this, message);
		}
		else {
			String message = "Le joueur " + partie.joueurPerdant() + " est mené. ";
			message += "C'est à lui de choisir le prochain premier joueur.";
			Object[] choix = {Bouton.noir,Bouton.rouge};
			Object reponse = JOptionPane.showInputDialog(JeuVue.this, message, "Choix du premier joueur",
					JOptionPane.QUESTION_MESSAGE, null, choix, Bouton.noir);
			plateau = new Plateau();
			try {
				plateau.setJoueurCourant((Bouton) reponse);
			}
			catch(ButtonUpException bue) {
				System.out.println("Cette exception ne doit jamais se produire");
				System.exit(1);
			}
			vueDuPlateau.setPlateau(plateau);
			vueDuPlateau.configurer();
			joueurCourant.setText(plateau.getJoueurCourant().toString());
			setVisible(false);
			updateUI();
			setVisible(true);
		}
		
	}
	
	class VuePlateauListener implements PropertyChangeListener {
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			int numeroPile = (Integer) evt.getNewValue();
			Pile pileChoisie = plateau.getPlateau().get(numeroPile-1);
			if (pileChoisie.contientBlanc()) {
				numPile = numeroPile;
				etat = Statut.ARRIVEE;
				annuler.setEnabled(true);
				valider.setEnabled(true);
			}
			majChoix();
		}
	}
}