package edu.mermet.buttonup.modele;

import static org.junit.Assert.*;
import org.junit.Test;

public class PileTest {
    
    @Test
    public void testToString() {
        System.out.println("toString Pile");
        Pile instance = new Pile(Bouton.blanc);
        String expResult = "[blanc]";
        String result = instance.toString();
        assertEquals(expResult, result);
        Pile instance2 = new Pile(Bouton.rouge);
        expResult = "[rouge]";
        result = instance2.toString();
        assertEquals(expResult, result);
        Pile instance3 = new Pile(Bouton.noir);
        expResult = "[noir]";
        result = instance3.toString();
        assertEquals(expResult, result);
    }

    @Test
    public void testEmpiler() {
        System.out.println("empiler");
        Pile instance = new Pile();
        instance.empiler(Bouton.blanc);
        instance.empiler(Bouton.noir);
        instance.empiler(Bouton.blanc);
        instance.empiler(Bouton.rouge);
        String expResult = "[blanc,noir,blanc,rouge]";
        String result = instance.toString();
        assertEquals(expResult, result);
    }

    @Test
    public void testEquals() {
        System.out.println("equals Pile");
        Pile p1 = new Pile(Bouton.blanc);
        Pile p2 = new Pile(Bouton.rouge);
        Pile p3 = new Pile(Bouton.noir);
        Pile p4 = new Pile(Bouton.blanc);
        assertEquals(p1,p4);
        assertFalse(p1.equals(p2));
        assertFalse(p1.equals(p3));
    }

    @Test
    public void testContientBlancVrai1() {
        System.out.println("contient blanc vrai 1");
        Pile p1 = new Pile(Bouton.blanc);
        assertTrue(p1.contientBlanc());
    }

    @Test
    public void testContientBlancVrai2() {
        System.out.println("contient blanc vrai 2");
        Pile p1 = new Pile(Bouton.rouge);
        p1.empiler(Bouton.blanc);
        p1.empiler(Bouton.noir);
        p1.empiler(Bouton.rouge);
        assertTrue(p1.contientBlanc());
    }

    @Test
    public void testContientBlancFaux() {
        System.out.println("contient blanc faux");
        Pile p1 = new Pile(Bouton.rouge);
        p1.empiler(Bouton.noir);
        p1.empiler(Bouton.rouge);
        assertFalse(p1.contientBlanc());
    }
    
    @Test
    public void testNonVide() {
        System.out.println("Pile non vide");
        Pile p1 = new Pile(Bouton.rouge);
        assertTrue(p1.nonVide());
        p1.empiler(Bouton.blanc);
        assertTrue(p1.nonVide());
        p1.defiler();
        p1.defiler();
        assertFalse(p1.nonVide());
    }
    
    @Test
    public void testDefiler() {
        System.out.println("Defiler");
        Pile p1 = new Pile(Bouton.rouge);
        p1.empiler(Bouton.noir);
        p1.empiler(Bouton.blanc);
        p1.empiler(Bouton.rouge);
        Bouton b = p1.defiler();
        assertEquals("bouton enlevé rouge",b,Bouton.rouge);
        assertEquals("pile restante correcte","[noir,blanc,rouge]",p1.toString());
        b = p1.defiler();
        assertEquals("bouton enlevé noir",b,Bouton.noir);
        assertEquals("pile restante correcte","[blanc,rouge]",p1.toString());
        b = p1.defiler();
        assertEquals("bouton enlevé blanc",b,Bouton.blanc);
        assertEquals("pile restante correcte","[rouge]",p1.toString());
        b = p1.defiler();
        assertEquals("bouton enlevé rouge",b,Bouton.rouge);
        assertFalse("pile vide",p1.nonVide());
    }
}
