package edu.mermet.buttonup.ihm.vues;


import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

import edu.mermet.buttonup.modele.*;

public class PlateauVue extends JPanel {
	private Plateau modele;
	
	public PlateauVue(Plateau p) {
		this.setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
		setPlateau(p);
	}
	
	public void setPlateau(Plateau p) {
		modele = p;
		configurer();
	}
	public void configurer() {
		boolean estVisible = this.isVisible();
		this.setVisible(false);
		this.removeAll();
		int compteur = 1;
		for (Pile p : modele.getPlateau()) {
			PileVue vuePile = new PileVue(p, compteur);
			vuePile.addMouseListener(new EcouteurPile());
			vuePile.addMouseListener(new EcouteurPile2());
			this.add(vuePile);
			this.add(Box.createRigidArea(new Dimension(PileVue.WIDTH/2,PileVue.HEIGHT)));
			compteur++;
		}
		this.setVisible(estVisible);
	}
	
	class EcouteurPile extends MouseAdapter {
		public void mouseClicked(MouseEvent me) {
			PileVue source = (PileVue) me.getSource();
			int numPile = source.getNumPile();
			System.out.println("pile sur laquelle on a cliqué : " + numPile);
		}
	}
	
	class EcouteurPile2 extends MouseAdapter {
		public void mouseClicked(MouseEvent me) {
			PileVue source = (PileVue) me.getSource();
			int numPile = source.getNumPile();
			firePropertyChange("selection",0,numPile);
		}
	}
}