package edu.mermet.buttonup.ihm.vues;

import static org.junit.Assert.*;
import java.awt.* ;
import java.awt.event.* ;
import javax.swing.* ;
import org.junit.* ;
import edu.mermet.buttonup.modele.Bouton;
import edu.mermet.buttonup.modele.Pile;

public class PileVueTest {
	private JFrame fenetre;
	private Pile pile;
	private PileVue vue;
	private JComponent carreRouge;
	private JComponent carreBlanc;
	private JComponent carreNoir;
	private Color rouge;
	private Color blanc;
	private Color noir;
	
	@Before
	public void setUp() throws Exception {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				fenetre = new JFrame("test pile vue");
				JPanel refCoul = new JPanel();
				carreRouge = new Carre(Bouton.rouge);
				carreBlanc = new Carre(Bouton.blanc);
				carreNoir = new Carre(Bouton.noir);
				refCoul.add(carreRouge);
				refCoul.add(carreBlanc);
				refCoul.add(carreNoir);
				fenetre.add(refCoul,BorderLayout.NORTH);
				fenetre.pack();
				fenetre.setVisible(true);
			}});
		Thread.sleep(500);
		Robot robot = new Robot();
		Point pos = carreRouge.getLocationOnScreen();
		rouge = robot.getPixelColor(pos.x+5, pos.y+5);
		pos = carreBlanc.getLocationOnScreen();
		blanc = robot.getPixelColor(pos.x+5, pos.y+5);
		pos = carreNoir.getLocationOnScreen();
		noir = robot.getPixelColor(pos.x+5, pos.y+5);
	}
	
	@After
	public void tearDown() throws Exception {
		fenetre.dispose();
	}
	
	class Carre extends JComponent {
		private Bouton couleur;
		public Carre(Bouton c) {couleur = c;}
		public int getWidth() {return 20;}
		public int getHeight() {return 20;}
		public Dimension getPreferredSize(){return new Dimension(20,20);}
		private Color getColor(Bouton bouton) {
			Color retour = null;
			switch(bouton) {
				case rouge:
				retour = Color.red;break;
				case noir:
				retour = Color.black;break;
				case blanc:
				retour = Color.white;
			}
			return retour;
		}
		
		public void paint(Graphics g) {
			g.setColor(getColor(couleur));
			g.fillRect(0, 0, 19, 19);
		}
	}
}