package edu.mermet.buttonup;

import java.util.Scanner;

import edu.mermet.buttonup.modele.*;
import static java.lang.Math.abs;

public class ButtonUp {
	private Partie partie;
	private Plateau plateau;
	
    public ButtonUp() {
    	partie = new Partie();
    	plateau = null;
    }
    
    private void lireEtJouerCoup() {
    	Scanner clavier = new Scanner(System.in);
		boolean erreur = true;
		do {
			System.out.print("pile choisie : ");
			String saisie = clavier.nextLine();
			try {
				int numero = Integer.parseInt(saisie);
				plateau.semer(numero);
				erreur = false;
			}
			catch (NumberFormatException nfe) {
				System.out.println("Entez un nombre svp");
			}
			catch (ButtonUpException bue) {
				System.out.println(bue.getMessage());
			}
		}
		while (erreur);
    	
    }

    int jouerManche() {
    	while (!plateau.estTermine()) {
    		System.out.println(plateau);
    		System.out.println("Au joueur "+ plateau.getJoueurCourant() + " de jouer");
    		lireEtJouerCoup();
    	}
    	int score = 0;
    	try {
    		score = plateau.calculScore();
    	}
    	catch (ButtonUpException bue) {
    		System.out.println("Cette erreur ne doit jamais se produire");
    		System.exit(1);
    	}
    	return score;
    }
    
    void initPlateau(Bouton joueur) {
    	plateau = new Plateau();
    	if (joueur != Bouton.blanc) {
    		try {
    	    	plateau.setJoueurCourant(joueur);
    		}
    		catch(ButtonUpException bue) {
    			System.out.println("Cette erreur ne doit jamais se produire");
    			System.exit(2);
    		}
    	}
    }
       
    private void gererGagnantManche(int score) {
    	partie.ajouterScore(score);
		try {
			if (plateau.getGagnant() == Bouton.noir) {
				System.out.println("Le joueur noir marque " + abs(score));
			}
			else if (plateau.getGagnant() == Bouton.rouge) {
				System.out.println("Le joueur rouge marque " + abs(score));    			
			}
			else {
				System.out.println("match nul");
			}
		}
		catch (ButtonUpException bue) {
			System.out.println("Cette erreur ne doit jamais se produire");
			System.exit(3);
		}
    	
    }
    
    private void afficherGagnantPartie() {
    		Bouton joueurEnTete = partie.joueurGagnant();
    		if (joueurEnTete == Bouton.blanc) {
    			System.out.println("Match nul !");
    		}
    		else {
    			System.out.println("Le joueur "+ joueurEnTete + " a gagné");
    		}
    }

    void jouerPartie() {
    	Bouton joueurEnTete;
    	while (!partie.estTerminee()) {
    		joueurEnTete = partie.joueurGagnant();
    		initPlateau(joueurEnTete.opposant());
    		int score = jouerManche();
    		System.out.println("Fin de la manche");
    		gererGagnantManche(score);
    	}
    	afficherGagnantPartie();
    }
    
    public static void main(String [] args) {
    	ButtonUp jeu = new ButtonUp();
    	jeu.jouerPartie();
    }
}
