# Sujet n° 16 : Extraction des données AIS dans des fichiers CSV en fonction de différents critères

* Encadrant :* Claude Duvallet

## Contexte

AIS est une technologie radio qui combine le positionnement GPS, la communication VHF et d’autres sources de données pour permettre l’échange d’information entre différents acteurs du monde maritime (navires, ports, détroits, bouées, etc.). Les informations échangées concernent la vitesse, la position, la destination, les manœuvres et d’autres informations relatives aux navires et à leur navigation. Ce système aide à la navigation et permet l’organisation des secours en mer.

Nous collectons les données AIS via un récepteur et une antenne installée sur le toit de l’IUT. Nous collectons aussi des données en provenance d’une communauté “AIS HUB”. Ces données sont au départ sous une forme brute (binaire) mais un décodeur a été réalisé lors d’un projet précédent. Il permet de décoder ces fichiers de données pour fournir des fichiers texte (CSV).

Le standard est spécifié par plusieurs entités de régulation et le format des messages répond à une norme bien définie. On se réfère à la norme [ITU-R M.1371-4](http://www.allaboutais.com/jdownloads/AIS%20standards%20documentation/itu-m.1371-4-201004.pdf) et en particulier aux tableaux détaillant le contenu des messages, dans l’annexe 8, section 3 (message descriptions), page 100. Seuls les messages n° 1, 2, 3, 4, 5, 18 et 19 nous intéressent.

## Description

Le volume d’information que représentent les données AIS est très important et le traitement demande beaucoup de ressources. Le but de ce projet est d’organiser ces données afin d’accélérer les recherches effectuées. On envisage de découper le globe terrestre en plusieurs zones géographiques et de classer les messages AIS reçus par zone. Cela pourrait accélérer les futures requêtes effectuées sur des zones en particulier.

Dans ce projet, il y a donc deux aspects :

1. La possibilité de traiter des fichiers CSV contenant l’ensemble des messages du globe et d’en extraire un certain nombre de sous-fichiers par zones géographiques, par type de navire et par identifiant de récepteur AIS. Il s’agit de ne retenir les messages que des navires présents dans la zone géographique.
2. On pourra aussi envisager de leur appliquer un filtre pour ne garder qu’un message par période de temps. Par exemple, un message toutes les 10 minutes.
3. On peut envisager de fournir des coordonnées sous forme d’un polygone représentant la zone à traiter ou alors fournir un fichier CSV comportant une liste de zones avec un nom et des coordonnées.

Un premier travail a déjà été effectué mais les performances de ce programme reste à améliorer et certaines fonctionnalités devront être ajoutées.

De plus le programme ne prends en charge qu’un seul format de fichiers CSV. Il faudrait donc qu’il puisse en prendre d’autres en considération.

## Technologies

* Langage de programmation : Python
* Ressources informatiques : Serveurs de calcul et stockage du LITIS.
