# Sujet n° 15 : Modélisation en NetLogo des pools de mineurs dans les blockchains

*Encadrants :* Cyrille Bertelle, Claude Duvallet, Aicha Ferjani, Maxence Lambard

## Description

La blockchain est une technologie qui permet de sécuriser des transactions. Sa première utilisation a permis de sécuriser des transactions d’actifs financiers (appelés monnaies cryptographiques) avec le Bitcoin mis en place depuis 2008. Depuis 2014, le concept de smart contract proposé par Ethereum vise à sécuriser des transactions plus complexes que des simples échanges de valeurs (financières). Les transactions sont inscrites dans un registre numérique que l’on peut comprendre comme une forme numérique de registre notarial (d’où le nom de « Distributed Ledger Technologie » parfois utilisé pour désigner la technologie blockchain). La sécurisation est basée, entre autres, sur le partage de ce registre numérique qui est dupliqué et distribué dans un réseau pair à pair géré par des participants contribuant ainsi au bon fonctionnement du système et qui sont appelés validateurs (ou mineurs dans le cas du Bitcoin). Pour inscrire une nouvelle transaction, un mécanisme de consensus est nécessaire pour que celle-ci soit validée par l’ensemble de ces validateurs mais aussi pour sélectionner le validateur qui sera rémunéré pour inscrire la transaction, afin d’assurer un modèle économique indispensable au bon fonctionnement. Ce mécanisme de consensus entre validateurs est un point critique de la technologie blockchain. Le travail proposé ici consiste à modéliser les comportements des validateurs au cours de ce mécanisme, en s’appuyant sur la théorie des jeux.

Pour réaliser des mécanismes de consensus coûteux en ressources informatiques, les mineurs dans BitCoin décident de s’organiser en pool afin de coopérer et augmenter leur chance de sélection face aux autres mineurs ou pools de mineurs. Augmenter leur chance d’être sélectionné va leur permettre d’augmenter leur rémunération qui est alors partagée entre les membres du pool sélectionné. Ainsi la création dynamique de pools génèrent des processus comportementaux complexes basés sur de la coopération et de la compétition que les modèles de théorie des jeux sont efficaces à formaliser.

## Travail attendu

1. Comprendre le fonctionnement des technologies blockchains et du mécanisme de consensus basé sur la preuve de travail (en vigueur dans BitCoin).
2. Se documenter sur le fonctionnement des pools de mineurs, notamment en lisant l’article de Ittay Eyal[^1] donné en référence ci-dessous.
3. Comprendre et pratiquer la plateforme multi-agents NetLogo[^2] en recherchant notamment des modèles pouvant se rapprocher du sujet proposé.
4. Spécifier puis implémenter un modèle de fonctionnement de pools de mineurs sur blockchains à l’aide de NetLogo.

## Références

[^1]: Ittay Eyal, « The Miner’s Dilemma”, In 2015 IEEE Symposium on Security and Privacy, pages 89–103. IEEE. Accessible depuis Arxiv : https://arxiv.org/pdf/1411.7099

[^2]: https://ccl.northwestern.edu/netlogo/