# Sujet n° 14 : Développement d'une application mobile de gestion de billets électroniques basée sur la blockchain

*Encadrants :* Maxence Lambard, Cyrille Bertelle, Claude Duvallet et Aicha Ferjani

## Description

Ce projet de TPE propose de développer une application mobile permettant de gérer des billets électroniques sécurisés via la technologie blockchain, en prenant exemple sur l'application TixNGo[^1]. L'objectif est de concevoir une solution permettant aux utilisateurs d'acheter, transférer et revendre des billets d'événements de manière infalsifiable et sécurisée. Grâce à la technologie blockchain, chaque
billet est unique, traçable et protégé contre la fraude.

L'implémentation de Smart Contracts[^2] sur la blockchain Ethereum[^3] sera une partie essentielle du projet, automatisant les transactions des billets lors des reventes ou transferts entre utilisateurs. Les
organisateurs d'événements pourront créer et distribuer des billets avec un suivi en temps réel, bénéficiant de la transparence et de la sécurité inhérentes à la blockchain.

Les technologies utilisées incluront React Native[^4] pour le développement de l'application mobile, la blockchain Ethereum pour la gestion des transactions et Metamask[^5] pour la gestion des portefeuilles
numériques. Le livrable final consistera en un prototype fonctionnel de l'application, accompagné d'une documentation complète sur l'architecture blockchain et les smart contracts, ainsi qu'une analyse approfondie de la sécurité et des performances de la solution. Ce projet offre une occasion unique d'explorer les interactions entre blockchain, développement mobile et sécurité des données dans un contexte d'application réel et pertinent.

## Références

[^1]: « The new mobile ticketing solution for events | TIXNGO ». Disponible sur : https://www.secutix.com/tixngo

[^2]: N. Szabo, « Smart Contracts: Building Blocks for Digital Markets ». 1996. Disponible sur : http://www.truevaluemetrics.org/DBpdfs/BlockChain/Nick-Szabo-Smart-Contracts-Building-Blocks-for-Digital-Markets-1996-14591.pdf

[^3]: « Le guide complet sur Ethereum | ethereum.org ». Disponible sur : https://ethereum.org/fr/

[^4]: « React Native · Learn once, write anywhere ». Disponible sur: https://reactnative.dev/

[^5]: MetaMask. “MetaMask”. Disponible sur : https://metamask.io/
