# Sujet n° 13: Simulation d'un réseau de transport avec NetLogo et ancrage dans la blockchain

*Encadrants :* Aicha Ferjani, Claude Duvallet, Cyrille Bertelle, Maxence Lambard

## Description

Dans le cadre du transport synchromodal de conteneurs[^1], les marchandises passent souvent par différents modes de transport (route, rail, fleuve) et différents acteurs (expéditeur, transporteur, gestionnaire de terminaux, etc.). Chaque fois qu'un conteneur change de main ou de moyen de transport, des autorisations spécifiques sont requises pour assurer une gestion sécurisée et conforme aux
réglementations. Par exemple, lorsqu'un conteneur contenant des produits chimiques passe d'un transport par camion à un train, une nouvelle autorisation de transport doit être délivrée, et cette
autorisation doit être vérifiée par les différentes parties prenantes, telles que le transporteur ferroviaire et les autorités locales.

Le principal défi dans ce contexte est de garantir la sécurisation des informations sensibles relatives aux autorisations de transport tout au long du parcours du conteneur. Traditionnellement, ces autorisations sont traitées par des systèmes distincts et centralisés, ce qui peut entraîner des erreurs, des pertes de données et des risques de fraude. En outre, la coordination entre les différents acteurs de la chaîne de transport n'est pas toujours fluide, et un manque de transparence sur l'état des autorisations peut provoquer des retards, surtout si des documents sont perdus ou mal transmis.

Dans ce contexte, la blockchain[^2] semble être une solution intéressante pour sécuriser et faciliter l'échange d'informations sensibles. En intégrant la blockchain, il est possible de créer un registre partagé et immuable des autorisations de transport, accessible à toutes les parties prenantes.

Le but de ce projet est de simuler le processus de transport des conteneurs dans un réseau synchromodal en utilisant NetLogo[^3], tout en intégrant l'ancrage des autorisations dans la blockchain. Cette approche vise à sécuriser les informations relatives aux autorisations et à améliorer la collaboration entre les différents acteurs de la chaîne logistique.

## Références

[^1]: Ferjani, A., El Yaagoubi, A., Boukachour, J., & Duvallet, C. (2024). An optimization-simulation approach for synchromodal freight transportation. Multimodal Transportation, 3(3), 100151. https://doi.org/10.1016/j.multra.2024.100151

[^2]: Mohanta, B. K., & Jena, D. (2018). An Overview of Smart Contract and Use cases in Blockchain Technology. 2018 9th International Conference on Computing, Communication and Networking Technologies (ICCCNT), November, 1–4. https://doi.org/10.1109/ICCCNT.2018.8494045

[^3]: https://ccl.northwestern.edu/netlogo/