# Sujet n° 12 : Comparaison entre STV et vote proportionnel

*Encadrant :* Frédéric Serin

Le système de vote STV pour *Single Transferable Vote* est un vote plurinominal transférable. Inventé
au XIXe siècle par Thomas Hare, il est en concurrence directe avec le scrutin proportionnel.

L'objectif de ce projet est de comparer les résultats possibles à travers diverses simulations entre ces
deux systèmes de vote.

## Principes

La grande différence entre système proportionnel par liste et système plurinominal transférable (STV)
est que dans le premier une liste bloquée est proposée alors que dans le second les électeurs placent
qui ils veulent dans l'ordre de leur choix.

Le second système est plus complexe à mettre en place s'il faut élire plusieurs personnes, au delà de
six ou sept, cela commence à devenir un peu complexe pour le votant.

L'avantage est qu'il permet aux électeurs de ne pas choisir par défaut le premier de liste, et aussi de
voter pour une personne qui n'aurait pu constitué de liste.

Le premier système est apprécié des partis qui peuvent ainsi imposer leurs choix ordonnés et éviter
ainsi que le leader d'un parti ne soit pas élu...

## Simulation

Pour éviter de tomber dans des combinaisons qui deviendraient fort complexes, on limitera la
simulation à des cas de petite taille : une centaine d'électeurs et 3 ou 5 sièges à pourvoir.

L'objectif est de comparer les deux systèmes de vote et de constater la proximité entre ces deux
modes de répartition.

## Résultat

Le code pour le système STV est fourni en Java.

Il faudra ensuite créer un simulateur de génération de bulletins de vote et compiler des comparaisons
entre systèmes.
