# Sujet n° 11 : Prédiction des Temps d'Arrivée des Navires (ETA)

*Encadrants :* Dominique Fournier, Yoann Pigné

## Contexte

Dans le monde de la logistique maritime, prédire avec précision les temps d'arrivée des navires est crucial pour optimiser les opérations et réduire les coûts. Ce projet vise à tirer parti des données de trafic maritime mondial déjà disponibles pour anticiper les ETA (*Estimated Time of Arrival*) et ainsi améliorer l'efficacité des chaînes d'approvisionnement.

## Objectifs

1. **Accès aux Données** :
   - Exploiter les données sur les navires, les ports et les dates afin d'extraire des informations clés pour les analyses.

2. **Analyse et Préparation** :
   - Nettoyer et préparer les données pour qu'elles soient prêtes à l'emploi.
   - Générer des caractéristiques intéressantes, telles que le temps écoulé depuis la dernière arrivée ou les distances entre ports.

3. **Modélisation** :
   - Concevoir un modèle prédictif pour estimer les ETA, en utilisant des techniques variées (régression, forêts aléatoires, XGBoost).
   - Mesurer la performance du modèle avec des indicateurs pertinents comme le RMSE et le MAE.

4. **Visualisation** :
   - Produire des graphiques et des cartes géospatiales pour rendre compte des résultats obtenus.
   - Identifier et analyser les facteurs clés qui influencent les ETA.

5. **Interface Utilisateur** (optionnel) :
   - Développer une application web (avec Flask ou FastAPI) qui permettra aux utilisateurs de consulter les prévisions d'ETA de manière interactive.

## Livrables

- Un rapport complet sur le projet.
- Des scripts Python bien documentés, couvrant la collecte, le traitement et la modélisation des données.
- Des visualisations percutantes (graphiques, cartes).

## Outils Recommandés

- **Base de Données** : PostgreSQL avec PostGIS pour gérer et analyser les données géospatiales.
- **Langage de Programmation** : Python, idéal grâce à ses nombreuses bibliothèques dédiées à la science des données et à l'apprentissage automatique.
- **Bibliothèques Python** :
  - `Pandas` : Pour la manipulation et l'analyse des données.
  - `NumPy` : Pour les calculs numériques.
  - `Scikit-learn` : Pour développer et évaluer des modèles d'apprentissage automatique.
  - `Matplotlib` et `Seaborn` : Pour créer des visualisations de qualité.
  - `Folium` ou `Geopandas` : Pour la visualisation géospatiale.

## Conclusion

Ce projet représente une occasion unique d'appliquer des compétences en science des données et en apprentissage automatique à un défi réel, tout en utilisant des outils et technologies à la pointe de l'industrie. Plongez-vous dans ce projet stimulant et contribuez à l'amélioration de la logistique maritime !
