# Sujet n° 9 : Optimisation du transport frigorifique : simulation java de re-routage de camions

*Encadrants :* Moustafa Nakechbandi (`nakechb at free dot fr`), Yoann Pigné

## Description du problème

La nécessité de faire fonctionner ensemble efficacement des réseaux logistiques
routiers, ferroviaires, maritimes et aériens pousse à la standardisation des transports de marchandises, tout en
s'inspirant également des réseaux informatiques de grande envergure, le plus célèbre étant Internet physique
[^1],[^2]. Dans cet esprit, nous supposerons ici que nous disposons de containers frigorifiques standardisés de
taille 1 que l'on peut manipuler pour constituer des chargements à peu près similaires à des paquets dans les
réseaux informatiques.

Cependant, ces conteneurs ne peuvent pas être gérés comme de simples paquets d'informations. L'un des
problèmes réside dans le fait qu'il existe un nombre limité de conteneurs réfrigérés (appelés également
"reefers" ou wagons porte-voitures) qui sont rares et coûteux. De plus, un déséquilibre dans les flux peut
entraîner le vidage de ces ressources spécialisées au même endroit, alors qu'elles seraient nécessaires ailleurs
pour être rechargées. Par conséquent, il est nécessaire de les récupérer d'une manière ou d'une autre. Nous
appelons ce problème "le problème du rééquilibrage des ressources mobiles rares dans un Internet
Physique".

Nous allons modéliser ce problème sous la forme d'un graphe représentant une zone géographique, avec des
centres routiers où les conteneurs peuvent être pris ou déposés.

![camions](camions.png)

Des camions circulent dans cette zone, prenant ou déposant ces conteneurs, et les arcs sont libellés en
fonction de leurs coûts.

Par exemple, dans le graphe ci-dessus, nous étudions le cas d'un ensemble de m camions vides, tous partant
du Centre A et devant retourner au Centre F. Ce retour à vide a un coût de 17, calculé en utilisant le Plus
Court Chemin (PCC) de (A, F) = 17, correspondant au coût de retour du camion.

L'objectif est de trouver de nouveaux itinéraires de A à F qui permettent de prendre des conteneurs vides en
cours de route pour les livrer plus loin, moyennant rémunération. Ces itinéraires doivent être aussi rentables
que possible, tout en ne coûtant pas plus cher que le retour direct à vide pour les camions.

### Exemple :
  * La capacité d'un camion est définie comme k = 2.
  * Il y a 3 camions en A et aucun ailleurs.
  * Le Plus Court Chemin (PCC) de A à F est A, B, D, E, F, avec un coût de 17.

Supposons une solution où l'on paie en moyenne 4 unités par conteneur pris là où il y en a en excès, et
déposé là où il en manque. Imaginons que cette solution soit la suivante :

  * Déviation du camion 1 : Nouveau trajet A, C, E, F avec un coût de 25 - 2 * 4 = 17.
  * Déviation du camion 2 : Nouveau trajet A, B, D, E, F avec un coût de 17 - 2 * 4 = 9.
  * Déviation du camion 3 : Nouveau trajet A, B, D, G, D, E, F avec un coût de 35 - 2 * 4 = 27.

On constate que la solution ci-dessus permet de déplacer 6 conteneurs depuis des endroits où ils sont
disponibles vers des endroits où ils sont demandés. Le coût supplémentaire est de (17 - 17) + (9 - 17) + (27 -
17) = 0 - 8 + 10 = 2 unités à payer en plus aux camions pour qu'ils acceptent ces nouveaux trajets.
Est-il possible de trouver une solution à moindre coût ? Comment ?

La référence [^3],[^4] propose un algorithme pour résoudre ce problème. Cet algorithme fournit une solution
optimale lorsque les ressources (nombre de camions) ne sont pas limitées. Cependant, en cas de limitation
des ressources, il propose une heuristique. Il est important de noter que cette heuristique prend en compte les
cas potentiels de "famine" (starvation), car certains nœuds très éloignés des trajets habituels risquent de ne
jamais être desservis.

## Travail à effectuer

Dans le cadre de ce projet, les tâches sont les suivantes :

### Première partie
  * Étudier le problème ainsi que l'algorithme décrit dans l'article [^3],[^4], qui a été préalablement abordé dans le projet TPE M1 (2020/2021) [^8]. L'objectif est de programmer cet algorithme sous forme de modules Java pour son intégration au logiciel AnyLogic [^6], [^7]. Nous effectuerons également des simulations visuelles pour évaluer son efficacité.
  * Ajouter un module Java qui générera automatiquement une série de graphes de tests. Ces graphes serviront à collecter des statistiques permettant d'évaluer la qualité des heuristiques proposées.

### Deuxième partie :

  1. Dans le problème actuel, une hypothèse implicite est que chaque camion n'effectuera qu'une seule opération de déviation "chargement-déchargement" lors de son voyage de retour. Cependant, pour nos travaux futurs, nous prévoyons de considérer des solutions comportant plusieurs opérations de déviation (multi-déviations).
  2. Nous disposons déjà d'une heuristique résolvant partiellement le problème des multi-déviations. L'objectif final de ce projet TPE est de tester l'efficacité de cette heuristique d'une part, et d'autre part, de proposer et de programmer d'autres heuristiques pour résoudre ce même problème.


## Références
[^1]: *Functional Design of Physical Internet Facilities: A Road-Rail Hub*, E. Ballot. B. Montreuil. C.
Thivierge. Report CIRRELT-2013-14, (2013).

[^2]: *A Proposal for an Open Logistics Interconnection Reference Model for a Physical Internet*, J.-Y. Colin,
H. Mathieu, M. Nakechbandi, 3rd International IEEE Conference on Logistics Operations Management,
23-25 May 2016, FEZ-Marocco (2016).

[^3]: *La gestion des ressources mobiles rares dans un Internet Physique sans ressources dédiées*, M.
Nakechbandi, J.-Y. Colin, H. Mathieu, LOGISTIQUA, International Colloquium of Logistics and
Supply Chain Management, Edition 2019 à l'IUT de Montreuil, France ,12-14 juin 2019 (2019).
[(pdf)](http://nakechb.free.fr/articles/logistiqua_28.pdf)

[^4]: *Studying the Rerouting of Empty Carriers during their Return Trips to Manage Rare Mobile Resources
in a Physical Internet*, M. Nakechbandi, J.-Y. Colin, GOL 2020.
[(pdf)](http://nakech.free.fr/articles/gol20_paper_9.pdf)

[^5]: *Un problème de tournée inspiré par la régulation des systèmes de transport en libre-service*, Meunier F.,
journée JFRO, 3-2012, Paris.
[(pdf)](http://www.lamsade.dauphine.fr/~jfro/JourneesPrecedentes/anciennesJournees/docs/jfro26/expose-2.pdf)

[^6]: AnyLogic : « Fonctions d’AnaLogic » (http://www.anylogic.fr/overview)

[^7]: Wikipedia (2015): « AnyLogic » (https://fr.wikipedia.org/wiki/AnyLogic).

[^8]: *Implémentation en Java et Simulation via Anylogic, d’algorithmes de re-routage de camions pour aller
chercher des conteneurs frigorifiques vides, Simulation avec AnyLogic*, Noel Camara et
Mamadou Saliou Dile Diallo, Rapport projet TPE 2021
[(pdf)](http://nakech.free.fr/rapports_projets/Rapport_TPE_2021.pdf)
