# Sujet n° 1 : Résolution du problème de tournées de véhicules avec temps de service variable

*Encadrant :* Christophe Duhamel

*Langage :* C++ ou python

Le problème de tournées de véhicules est un problème central en transport. Il consiste à visiter un
ensemble de clients à l'aide d'une flotte de véhicules, chaque client étant traité une seule fois et par un seul
camion. De nombreuses variantes existent et la littérature consacrée au problème est abondante. Nous considérons
ici une version dans laquelle chaque client doit être visité dans une fenêtre de temps (VRPTW) et le temps de service
pour traiter chaque client n'est pas constant. Il peut varier dans un intervale `[min, max]` et on associe une notion
de Qualité de Service (QoS) au temps passé pour traiter le client. Le problème possède ainsi deux objectifs :
minimiser le temps total de trajet et maximiser la somme des QoS. On doit donc trouver un compromis entre ces
deux critères.

La première partie du travail sera dédiée à la modélisation du problème. On étudiera différentes manière de
considérer de temps de service (une constante, une variable continue, une variable discrète, une variable aléatoire)
et différentes formes de fonctions de QoS (discrète, continue, linéaire, non-linéaire, croissante, décroissante).
Ces choix conditionnent le modèle et on analysera donc leur impact. Dans un second temps, on développera une
heuristique constructive permettant de calculer une solution à partir d'une séquence des clients, par exemple en
partant d'une tournée vide et en insérant les clients les uns à la suite des autres dans l'ordre de la séquence.
On proposera plusieurs versions de cette heuristique selon le critère d'insertion du client courant, le critère
de choix de la tournée et le critère de choix de la durée de service. Cette heuristique sera ensuite intégrée dans
un algorithme génétique multi-objectif dont le code sera fourni, NSGA-II. On pourra alors étudier les solutions
obtenues pour les différentes formes de fonction QoS, en se concentrant sur quelques applications :

- la QoS est une probabilité cumulative de succès du service
- la durée est un temps de recharge du véhicule électrique et la QoS est inversement proportionnelle à la durée$
- la QoS est un niveau de service (silver/gold/platinum) dépendant du niveau de prestation chez le client.
