# Sujet n°10 : Conception d'un outil d'extraction de données pour la planification de secours d'urgence en zone urbaine

*Encadrant :* Christophe Duhamel

*Technologies :* Python, OSMNx

La phase de réponse suite à une catastrophe majeure en milieu urbain est critique pour maîtriser l'impact sur la population. Il s'agit de sécuriser les lieux et de fournir des soins d'urgence aux personnes blessées. Les hôpitaux étant rapidement saturés, la protection civile met en place des tentes médicalisées pour
  * effectuer un triage en fonction de la gravité des blessures et, en fonction du degré de gravité,
  * le traitement sur place ou
  * le transfert vers un hôpital.

Le choix d'implantation des tentes a un impact direct sur la qualité de l'accès de la population aux soins. La disposition d'outils d'aide à la décision peut grandement faciliter cette étape.

Dans le projet, on va dans un premier temps mettre en place des scripts python permettant de récupérer les points d'une agglomération (hôpitaux et cliniques, gymnases et stades, zones dégagées) depuis OpenStreetMap. D'autres scripts serviront à récupérer aussi les informations de densité de population. Ces éléments seront géolocalisés, ce qui permettra de calculer la distance entre chaque point. On choisira un format de sauvegarde de ces données pour leur réutilisation dans un algorithme de localisation des tentes.

On définira ensuite des scénarios de catastrophe (nombre de personnes par niveau de blessure et par zone, nombre de tentes disponibles, capacité de chaque tente, capacité des hôpitaux) et on proposera des heuristiques simples pour positionner les tentes de manière de traiter le plus de personnes possible. Les solutions obtenues seront alors visualisées à l'aide d'un script python utilisant la bibliothèque OSMNx.
