# Sujet n° 6 : Automatisation de l’extraction des escales de navires sur une zone données

*Encadrants :* Claude Duvallet, Ronan Kebiriou

## Contexte

AIS est une technologie radio qui combine le positionnement GPS, la communication VHF et d’autres sources de données pour permettre l’échange d’information entre différents acteurs du monde maritime (navires, ports, détroits, bouées, etc.). Les informations échangées concernent la vitesse, la position, la destination, les manœuvres et d’autres informations relatives aux navires et à leur navigation. Ce système aide à la navigation et permet l’organisation des secours en mer.
Nous collectons les données AIS via un récepteur et une antenne installée sur le toit de l’IUT. Nous collectons aussi des données en provenance d’une communauté “AIS HUB” et du GPMH (Grand Port Maritime du Havre). Ces données sont au départ sous une forme brute (binaire) mais un décodeur a été réalisé lors d’un projet précédent. Il permet de décoder ces fichiers de données pour fournir des fichiers texte (CSV).

Le standard est spécifié par plusieurs entités de régulation et le format des messages répond à une norme bien définie. On se réfère à la norme [ITU-R M.1371-4](http://www.allaboutais.com/jdownloads/AIS%20standards%20documentation/itu-m.1371-4-201004.pdf) et en particuliers aux tableaux détaillant le contenu des messages, dans l’annexe 8, section 3 (message descriptions), page 100. Seuls les messages n° 1, 2, 3, 4, 5, 18 et 19 nous intéressent.

## Description

Nous souhaitons connaître à partir des messages AIS, connaître les escales des navires. Pour cela, nous commençons par agréger les données sur 5 jours, puis ne garder que les données concernant une zone géographique donnée. Ensuite, nous utilisons une de données des terminaux afin de ne garder que les navires se trouvant dans un rayon de 500 mètres et circulant à une vitesse inférieure à 2 nœuds. Pour chaque ligne (message AIS) extraite, nous ajoutons le nom du port et du pays par recoupement avec la base de données Port. Enfin, nous trions les données par MMSI et date avant de ne garder que le premier et dernier message pour un même trio (MMSI, Port, Pays) sur une période de 24h.

Il s’agit donc de développer un programme permettant d’automatiser toutes ces étapes tout en étant paramétrable au niveau de la zone géographique donnée, la durée d’agrégation des données, le rayon autour des ports, la vitesse des navires et la période.

Ces paramètres pourront être spécifier dans un fichier CSV ou en ligne de commande au choix de l’utilisateur.

En option, on peut envisager de restreindre le type de navire par recoupement avec la base de donnée Navire et rajouter le numéro IMO pour chaque navire.

## Technologies
  * Langage de programmation : Python
  * Ressources informatiques : Serveurs de calcul et stockage du LITIS.
