package tp4.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import tp4.Fenetre;

public class ActionReset extends AbstractAction {
  private Fenetre fenetre;
  public ActionReset(Fenetre f) {
    super("Reset");
    putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke("control Z"));
    putValue(SHORT_DESCRIPTION, "Annule toutes les modifications");
    putValue(MNEMONIC_KEY, KeyEvent.VK_Z);
    this.fenetre = f;
    if (f.getIcon() == null)
      this.setEnabled(false);
  }

  @Override
  public void actionPerformed(ActionEvent e) {
    this.fenetre.setIcon(new ImageIcon(this.fenetre.getImage()));
    this.setEnabled(false);
    this.fenetre.setTitle("TP4 - exercice B");
  }
}
