package tp4.actions;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.concurrent.Flow;

import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

import tp4.Fenetre;
import tp4.util.UtilitaireFichierImage;

public class ActionConfigurer extends AbstractAction {
	Fenetre f;
	JPanel p;
	JComboBox<Valeur> selection;
	public ActionConfigurer(Fenetre f) {
        super("Configurer");
        putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke("control F"));
        putValue(SHORT_DESCRIPTION, "Configurer le pas");
        putValue(MNEMONIC_KEY, KeyEvent.VK_F);
        this.f = f;
    }
	@Override
	public void actionPerformed(ActionEvent arg0) {
		JDialog d = new JDialog(f, true);
		JPanel p2 = new JPanel();
		p = new JPanel();
		JPanel PaneDia = new JPanel();
		
		PaneDia.setLayout(new BoxLayout(PaneDia ,BoxLayout.Y_AXIS));
		
		
        p.setSize(300,300);
        selection = new JComboBox<Valeur>();
        selection.addItem(new Valeur(0.10f, "10%"));
        selection.addItem(new Valeur(0.20f, "20%"));
        selection.addItem(new Valeur(0.30f, "30%"));
        selection.addItem(new Valeur(0.40f, "40%"));
        selection.addItem(new Valeur(0.50f, "50%"));
        JLabel icon = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
        p.add(icon);
        p.add(selection);
		
		JButton boutonValider = new JButton(new AbstractAction() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				Valeur val= (Valeur) selection.getSelectedItem();
				f.setPas(val.value);
				d.dispose();
			}
		});
		boutonValider.setLabel("OK");
		JButton boutonQuitter = new JButton(new AbstractAction() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				d.dispose();
			}
		});
		boutonQuitter.setLabel("Quitter");
		
		p2.add(boutonValider);
		p2.add(boutonQuitter);
		
		PaneDia.add(p);
		PaneDia.add(p2);
		
		PaneDia.setSize(300,300);
		d.setContentPane(PaneDia);
		
		d.pack();
		d.setLocationRelativeTo(f);
		d.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		d.setVisible(true);
	}
	public class Valeur {
		public float value;
		public String nom;
		public Valeur(float value, String nom) {
			this.value = value;
			this.nom = nom;
		}
		public String toString() {
			return nom;
		}
	}
}
