package tp4.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;

import tp4.Fenetre;
import tp4.Main;
import tp4.util.UtilitaireFichierImage;

public class ActionSauver extends AbstractAction{
	Fenetre f;
	public ActionSauver(Fenetre f) {
        super("Sauver");
        putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke("control S"));
        putValue(SHORT_DESCRIPTION, "Sauver une image");
        putValue(MNEMONIC_KEY, KeyEvent.VK_S);
        this.f = f;

    }
	@Override
	public void actionPerformed(ActionEvent arg0) {
		String nomFich = UtilitaireFichierImage.getNomSansExtension(f.getImage());
		File fich= new File(nomFich+"1"+UtilitaireFichierImage.getExtensionAvecPoint(f.getImage()));
		UtilitaireFichierImage.sauverImage(fich, f.getIcon());
	}

}