package tp4.actions;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import tp4.Fenetre;
import tp4.util.UtilitaireFichierImage;

public class ActionConfigurer extends AbstractAction {
	Fenetre f;
	JPanel p;
	JComboBox<Valeur> selection;
	public ActionConfigurer(Fenetre f) {
        super("Configurer");
        putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke("control F"));
        putValue(SHORT_DESCRIPTION, "Configurer le pas");
        putValue(MNEMONIC_KEY, KeyEvent.VK_F);
        p = new JPanel();
        p.setSize(300,300);
        selection = new JComboBox<Valeur>();
        selection.addItem(new Valeur(0.90f, "10%"));
        selection.addItem(new Valeur(0.80f, "20%"));
        selection.addItem(new Valeur(0.70f, "30%"));
        selection.addItem(new Valeur(0.60f, "40%"));
        selection.addItem(new Valeur(0.50f, "50%"));
        p.add(selection);
    }
	@Override
	public void actionPerformed(ActionEvent arg0) {
		JDialog d = new JDialog(f, true);
		JPanel p2 = new JPanel();
		d.setLayout(new FlowLayout());
		JButton boutonValider = new JButton(new AbstractAction() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				Valeur val= (Valeur) selection.getSelectedItem();
				
				f.setPas(val.value);
				
			}
		});
		boutonValider.setLabel("OK");
		p2.add(boutonValider);
		JButton boutonQuitter = new JButton(new AbstractAction() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				d.dispose();
				
			}
		});
		boutonQuitter.setLabel("Quitter");
		p2.add(boutonQuitter);
		d.add(p);
		d.add(p2);
		d.setSize(300,300);
		d.setVisible(true);
	}
	public class Valeur {
		float value;
		String nom;
		public Valeur(float value, String nom) {
			this.value = value;
			this.nom = nom;
		}
		public String toString() {
			return nom;
		}
	}
}
