package tp4;

import java.awt.BorderLayout;
import java.awt.Font;

import javax.swing.JFrame;
import javax.swing.JLabel;

import javax.swing.JMenu;
import javax.swing.JMenuBar;

import tp4.actions.ActionCharger;
import tp4.actions.ActionQuitter;

public class Fenetre extends JFrame {
    private ActionQuitter quitter;
    private ActionCharger charger;
    
    public Fenetre() {
        this.setTitle("TP4");
	init();
        pack();
	setLocationRelativeTo(null);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setVisible(true);
    }

    private void initActions() {
    	charger = new ActionCharger(this);
    	quitter = new ActionQuitter();
	    sauver =
	        new AbstractAction() {
	          @Override
	          public void actionPerformed(ActionEvent e) {}
	        };/**
	    configurer =
	        new AbstractAction() {
	          @Override
	          public void actionPerformed(ActionEvent e) {}
	        };**/
    }

    private void initMenus() {
      JMenuBar barre = new JMenuBar();
      JMenu mFichier = new JMenu("Fichier");
      mFichier.setMnemonic('F');
      mFichier.add(charger);
      mFichier.add(quitter);
      barre.add(mFichier);
      setJMenuBar(barre);
    }

    private void initComposants() {
	JLabel texte = new JLabel("À implanter");
	Font police = new Font(Font.DIALOG, 0, 64);
	texte.setFont(police);
	getContentPane().add(texte, BorderLayout.CENTER);
    }
    
    private void init() {
	initComposants();
	initActions();
	initMenus();
    }
}
