package tp4.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;

import tp4.Fenetre;
import tp4.Main;

public class ActionCharger extends AbstractAction{
	final JFileChooser fc = new JFileChooser();
	private Fenetre f;

	public ActionCharger(Fenetre f) {
        super("Charger");
        putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke("control O"));
        putValue(SHORT_DESCRIPTION, "Choisir une image");
        putValue(MNEMONIC_KEY, KeyEvent.VK_O);
        this.f = f;

    }
	@Override
	public void actionPerformed(ActionEvent arg0) {
		fc.showOpenDialog(f);
    f.setImage(fc.getSelectedFile().getAbsolutePath());
	}

}
