package tp4;

import java.awt.BorderLayout;
import java.io.File;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

import javax.swing.JMenu;
import javax.swing.JMenuBar;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import tp4.util.UtilitaireFichierImage;
import tp4.actions.ActionAugmenter;
import tp4.actions.ActionCharger;
import tp4.actions.ActionConfigurer;
import tp4.actions.ActionQuitter;
import tp4.actions.ActionSauver;
import tp4.actions.ActionDiminuer;
import tp4.actions.ActionReset;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class Fenetre extends JFrame {
    private ActionQuitter quitter;
    private ActionCharger charger;
    private ActionSauver sauver;
    private ActionConfigurer config;
    private ActionDiminuer diminuer;
    private ActionAugmenter augmenter;
    private ActionReset reset;
    private ImageIcon icone;
    private String image;
    private JLabel afficheurImage;
    private float pas = 0.1f;

  public float getPas() {
		return pas;
	}

	public void setPas(float pas) {
		this.pas = pas;
	}

	public Fenetre() {
        this.setTitle("TP4 - exercice B");
        this.initComposants();
	      init();
        setSize(300, 300);
	      setLocationRelativeTo(null);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setVisible(true);
    }

    public void setImage(String path) {
      icone = UtilitaireFichierImage.chargerImage(new File(path));
      if (icone != null) {
        diminuer.setEnabled(true);
        augmenter.setEnabled(true);
        afficheurImage.setIcon(icone);
        image = path;
      }
      if (icone == null) {
        diminuer.setEnabled(false);
        augmenter.setEnabled(false);
        image = null;
      }
    }

    public String getImage() {
    	return image;
    }

    public void setIcon(ImageIcon ic) {
      this.icone = ic;
      this.afficheurImage.setIcon(ic);
    }

    public ImageIcon getIcon() {
      return icone;
    }

    private void initActions() {
    	charger = new ActionCharger(this);
    	quitter = new ActionQuitter();
	    sauver = new ActionSauver(this);
	    config = new ActionConfigurer(this);
      diminuer = new ActionDiminuer(this);
      augmenter = new ActionAugmenter(this);
      reset = new ActionReset(this);
    }

    private void initMenus() {
      JMenuBar barre = new JMenuBar();
      JMenu mFichier = new JMenu("Fichier");
      mFichier.setMnemonic('F');
      mFichier.add(charger);
      mFichier.add(sauver);
      mFichier.add(config);
      mFichier.add(quitter);
      
      barre.add(mFichier);

      JMenu mImage = new JMenu("Image");
      mImage.setMnemonic('I');
      mImage.add(diminuer);
      mImage.add(augmenter);
      mImage.add(reset);

      barre.add(mImage);
      setJMenuBar(barre);
    }

    private void initComposants() {
      this.afficheurImage = new JLabel();
	    getContentPane().add(afficheurImage, BorderLayout.CENTER);
    }

    private void init() {
	    initComposants();
	    initActions();
	    initMenus();
    }

    public void enableReset() {
      this.reset.setEnabled(true);
    }

    public void disableReset() {
      this.reset.setEnabled(false);
    }
}
