package tp4.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

import tp4.Fenetre;
import tp4.util.UtilitaireFichierImage;

public class ActionDiminuer extends AbstractAction {
  private Fenetre f;

  public ActionDiminuer(Fenetre f) {
    super("Diminuer");
    putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke("control M"));
    putValue(SHORT_DESCRIPTION, "Diminuer la taille de l'image");
    putValue(MNEMONIC_KEY, KeyEvent.VK_M);
    this.f = f;
    if (f.getIcon() == null)
      this.setEnabled(false);
  }

	@Override
	public void actionPerformed(ActionEvent arg0) {
		f.setIcon(UtilitaireFichierImage.redimensionnerImage(f.getIcon(), 1 - f.getPas()));
	}
}
