package tp4;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

import javax.swing.JMenu;
import javax.swing.JMenuBar;

import tp4.actions.ActionCharger;
import tp4.actions.ActionConfigurer;
import tp4.actions.ActionQuitter;

import tp4.util.UtilitaireFichierImage;
import tp4.actions.ActionSauver;

public class Fenetre extends JFrame {
    private ActionQuitter quitter;
    private ActionCharger charger;
    private ActionSauver sauver;
    private ActionConfigurer config;
    private ImageIcon icone;
    private String image;
    private JLabel afficheurImage;
    private float pas;

    public float getPas() {
		return pas;
	}

	public void setPas(float pas) {
		this.pas = pas;
	}

	public Fenetre() {
        this.setTitle("TP4");
        this.initComposants();
	      init();
        setSize(300, 300);
	      setLocationRelativeTo(null);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setVisible(true);
    }

    public void setImage(String path) {
      icone = UtilitaireFichierImage.chargerImage(new File(path));
      afficheurImage.setIcon(icone);
      image = path;
    }
    public String getImage() {
    	return image;
    }

    public ImageIcon getIcon() {
      return icone;
    }

    private void initActions() {
    	charger = new ActionCharger(this);
    	quitter = new ActionQuitter();
	    sauver = new ActionSauver(this);
	    config = new ActionConfigurer(this);
    }

    private void initMenus() {
      JMenuBar barre = new JMenuBar();
      JMenu mFichier = new JMenu("Fichier");
      mFichier.setMnemonic('F');
      mFichier.add(charger);
      mFichier.add(sauver);
      mFichier.add(config);
      mFichier.add(quitter);
      
      barre.add(mFichier);
      setJMenuBar(barre);
    }

    private void initComposants() {
      this.afficheurImage = new JLabel();
	    getContentPane().add(afficheurImage, BorderLayout.CENTER);
    }

    private void init() {
	    initComposants();
	    initActions();
	    initMenus();
    }
}
