package tp4.util;

import java.io.File;
import java.io.IOException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.stream.Collectors;

public class UtilitaireFichierTexte {
  /**
   * Lit le contenu texte d'un fichier.
   * @param fichier le fichier
   * @return le texte contenu dans le fichier
   * @throws IOException en cas d'erreur de lecture
   */
  public static String getTexte(File fichier) throws IOException {
    BufferedReader reader = new BufferedReader(
        new InputStreamReader(
            new FileInputStream(fichier)
            )
        );
    String contenu = reader.lines().collect(Collectors.joining("\n"));
    reader.close();
    return contenu;
  }
  
  /**
   * Ecrit du texte dans un fichier.
   * @param fichier le fichier
   * @param texte le texte à écrire
   * @return true si l'écriture a réussi, false sinon
   */
  public static boolean ecrireTexte(File fichier, String texte) {
    boolean ok;
    try (PrintWriter sortie = new PrintWriter(fichier)) {
      sortie.println(texte);
      ok = true;
    } catch (FileNotFoundException fe) {
      System.err.println("Fichier non trouvé");
      ok = false;
    }
    return ok;
  }
}
