package tp4.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class UtilitaireFichierImage {

  /**
   * Permet, à partir d'un chemin d'accès complet à un fichier,
   * de récupérer le chemin sans l'extension du fichier
   * 
   * <i>Exemple</i> : si le chemin est "/home/toto/photo.jpg",
   * la méthode retourne "/home/toto/photo"
   * @param cheminImage le chemin complet de l'image
   * @return le chemin sans l'extension
   */
  public static String getNomSansExtension(String cheminImage) {
    return cheminImage.substring(0, cheminImage.lastIndexOf('.'));
  }

  /**
   * Permet, à partir d'un chemin d'accès complet à un fichier,
   * de récupérer l'extension du fichier, point compris.
   * 
   * <i>Exemple</i> : si le chemin est "/home/toto/photo.jpg",
   * la méthode retourne ".jpg"
   * @param cheminImage le chemin complet de l'image
   * @return l'extension avec le point
   */
  public static String getExtensionAvecPoint(String cheminImage) {
    return cheminImage.substring(cheminImage.lastIndexOf('.'));
  }

  /**
   * Permet de charger une image à partir d'un fichier.
   * @param fichier : le fichier image à charger
   * @return l'image chargée
   */
  public static ImageIcon chargerImage(File fichier) {
    ImageIcon image = new ImageIcon(fichier.getAbsolutePath());
    return image;
  }

  /**
   * Permet de sauvegarder une image dans un fichier.
   * 
   * @param fichier le fichier de destination
   * @param icone l'image à sauvegarder
   */
  public static void sauverImage(File fichier, ImageIcon icone) {
    BufferedImage bfi = new BufferedImage(icone.getIconWidth(), icone.getIconHeight(), BufferedImage.TYPE_INT_RGB);
    Graphics2D g2 = bfi.createGraphics();
    g2.drawImage(icone.getImage(), 0, 0, null);
    g2.dispose();
    try {
      ImageIO.write(bfi, "jpg", fichier);
    } catch (IOException e1) {
      System.out.println("Problème lors de la sauvegarde de l'image");
    }
  }

  /**
   * Permet de sauvegarder une image dans un fichier.
   * 
   * @param cheminFichier le chemin du fichier de destination
   * @param icone l'image à sauvegarder
   */
  public static void sauverImage(String cheminFichier, ImageIcon icone) {
    sauverImage(new File(cheminFichier), icone);
  }

}
