package com.example.austime.repository;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.provider.ContactsContract;
import android.util.Log;

import com.example.austime.db.contract.TimerDBContract;
import com.example.austime.db.helper.TimerDBHelper;
import com.example.austime.model.Timer;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class TimerRepository {

    private SQLiteDatabase db;
    private TimerDBContract dbContract;
    private  TimerDBHelper dbHleper;
    Context context;

    public TimerRepository(Context context) {
        this.context = context;
        dbHleper = new TimerDBHelper(context);
            db = new TimerDBHelper(context).getWritableDatabase();
    }

/*
    public void createDefaultNotesIfNeed()  {
        int count = this.getRowCount();
        if(count ==0 ) {
            Timer timer = new Timer();
          timer.setTitle("sdsdsd");
            timer.setStartDate("sqdqsd");
            timer.setTime("sqdqsd");
            this.addTask(timer);
            //this.addTask(note2);
        }
    }*/

    public long addTask(Timer timer) {
        ContentValues values = new ContentValues();
        db = new TimerDBHelper(context).getWritableDatabase();
        values.put(TimerDBContract.TimerEntry.COLUMN_NAME_TITLE, timer.getTitle());
        values.put(TimerDBContract.TimerEntry.COLUMN_NAME_START_TIME, timer.getStartDate().getTimeInMillis());
        values.put(TimerDBContract.TimerEntry.COLUMN_NAME_TIME, timer.getTime());

        return db.insert(TimerDBContract.TimerEntry.TABLE_NAME, null, values);

    }

    public int getRowCount( ) {
        String countQuery = "SELECT  * FROM " + TimerDBContract.TimerEntry.TABLE_NAME;
       // SQLiteDatabase db = new  TimerDBHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(countQuery, null);
        int count = cursor.getCount();
        cursor.close();
        return count;
    }



    ArrayList<Timer> taskList;

    public ArrayList<Timer> getAll() {
        Calendar cal = Calendar.getInstance();
        //SQLiteDatabase db = this.getReadableDatabase();
        String sql = "SELECT DISTINCT  * FROM " + TimerDBContract.TimerEntry.TABLE_NAME;
        Cursor cursor = db.rawQuery(sql, null);
        taskList = new ArrayList<>();

        if (cursor. moveToFirst() ) {
            do {
                //cursor.moveToNext();
                Timer timerInfo = new Timer();
                timerInfo.setId(cursor.getInt(0));
                timerInfo.setTitle(cursor.getString(1).trim());

                long l = cursor.getLong(cursor.getColumnIndexOrThrow(cursor.getColumnName(2)));
                cal.setTimeInMillis(l);
                timerInfo.setStartDate(cal);
                timerInfo.setTime(cursor.getInt(3));
                taskList.add(timerInfo);

            }while (cursor.moveToNext());
        }
        //getRowCount(cursor);

        cursor.close();
        db.close();
        return taskList;

    }
}
