package com.example.austime.db.helper;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.example.austime.db.contract.TimerDBContract;

public class TimerDBHelper extends SQLiteOpenHelper {

    public static final int DATABASE_VERSION = 1;
    public static final String DATABASE_NAME = "Timer.db";

    public TimerDBHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        createTimerRecurrenceTable(db);
        createTimerTable(db);
    }

    private void createTimerTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE " + TimerDBContract.TimerEntry.TABLE_NAME  + "("
                + TimerDBContract.TimerEntry._ID + " INTEGER PRIMARY KEY,"
                + TimerDBContract.TimerEntry.COLUMN_NAME_TITLE+ " TEXT NOT NULL,"
                + TimerDBContract.TimerEntry.COLUMN_NAME_START_TIME + " TEXT NOT NULL,"
                + TimerDBContract.TimerEntry.COLUMN_NAME_TIME + " TEXT NOT NULL"
                +")"
                ///+ TimerDBContract.TimerEntry.COLUMN_FK_TIMER_RECURRENCE + " INTEGER NOT NULL"
        );
    }

    private void createTimerRecurrenceTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE " + TimerDBContract.TimerRecurrenceEntry.TABLE_NAME  + "("
                + TimerDBContract.TimerRecurrenceEntry._ID + " INTEGER PRIMARY KEY,"
                + TimerDBContract.TimerRecurrenceEntry.COLUMN_NAME_TITLE + " TEXT NOT NULL,"
                + TimerDBContract.TimerRecurrenceEntry.COLUMN_NAME_DATE_KEY + " INTEGER NOT NULL,"
                + TimerDBContract.TimerRecurrenceEntry.COLUMN_NAME_DATE_VALUE + " INTEGER NOT NULL"
                + ")"
        );
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS " + TimerDBContract.TimerRecurrenceEntry.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + TimerDBContract.TimerEntry.TABLE_NAME);

        onCreate(db);
    }
}

