<?php

namespace App\Controller;


use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;


use App\Entity\Donnee;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class DonneeM2Controller
{

    private $em;

    public function __construct(EntityManagerInterface $em) {
        $this->em = $em;
    }

    public function __invoke(Request $data)
    {
        $query = "  SELECT SUM(data.valeurFonciere)/SUM(data.surface) as moyenne_surface, DATE_TRUNC('month', data.dateMutation) as month
                    FROM App:Donnee AS data
                    WHERE data.surface > 0 AND data.valeurFonciere > 0
                    GROUP BY month
                    ORDER BY month";

        $resQuery = $this->em->createQuery($query)->getResult();

        foreach ($resQuery as $donnee) {
            $donnee['moyenne_surface'] = floatval($donnee['moyenne_surface']);
            $donnee['month'] =  $donnee["month"];
        }

        return new JsonResponse($resQuery);
    }
}
