import React from 'react';
import '../../css/style.css';
import App from "./App";

class PrixM2 extends React.Component {

  constructor(props){
    super(props);
    this.state = {
      data: []
    }
  }

  getData(){
    fetch(`https://${document.domain}:8443/prix-m2`)
      .then(response => {
        if (response.ok) {
          return response.json();
        } else {
          throw new Error('error');
        }
      })
      .then(data => {
        this.setState({data: data });
      })
      .catch(error => console.log("error"));
  }

  componentDidMount(){
    this.getData();
  }

  render() {
    function parseData(data) {
      var arr = [];
      data.map(function (list){
        arr.push({
          annee: list.annee | 0,
          prixM2 : list.prixM2
        });
      })
      return arr;
    }

    const data =  parseData(this.state.data)
    console.log("ok"+data)

    return  (
      <div>
        <App/>
        PrixM2
        {this.state.data}
      </div>
    )
  }
}

export default PrixM2;
