<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

class DonneePourcentRegionController extends AbstractController
{
    public function __construct() {}

    public function __invoke(Array $data, string $year)
    {
        $nbVentesRegion = array();

        foreach ($data as $donnee) {
            $date = $donnee->getDateMutation()->format('Y');
            $region = $donnee->getRegion();

            if(strcmp($year, $date) == 0){
                if(!array_key_exists($region, $nbVentesRegion)){
                    $nbVentesRegion[$region] = 0;
                }
                $nbVentesRegion[$region] += 1;
            }
        }

        $listeReponse = array();
        foreach ($nbVentesRegion as $key => $nbVente) {
            $listeReponse[$key] = ($nbVente / array_sum($nbVentesRegion)) * 100;
        }

        return new JsonResponse(array("data"=>$listeReponse));
    }
}
