<?php
namespace App\Controller;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

use App\Entity\Donnee;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class DonneeNbVentesController
{
    public function __construct() {}

    public function __invoke(Array $data, string $unit, string $start, string $end)
    {
        $nbVentes = array();
        $startDate = date_create_from_format("j-m-Y", $start);
        $endDate = date_create_from_format("j-m-Y", $end);
        foreach ($data as $donnee) {
            $date = $donnee->getDateMutation();
            $formattedDate = $date->format($unit); /*d/m/Y ou m/Y ou Y*/

            if($date >= $startDate && $date <= $endDate){
                if(!array_key_exists($formattedDate, $nbVentes)){
                    $nbVentes[$formattedDate] = 0;
                }
                $nbVentes[$formattedDate] += 1;
            }
        }
        return new JsonResponse(array("data"=>$nbVentes));
    }
}
