<?php

namespace App\Controller;


use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;


use App\Entity\Donnee;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class DonneeM2Controller
{

    public function __construct() {

    }

    public function __invoke(Array $data)
    {
        $prixVenteParMois = array();
        foreach ($data as $donnee) {
            $moisAnnee = $donnee->getDateMutation()->format("m/Y");

            if(!array_key_exists($moisAnnee, $prixVenteParMois)){
                $prixVenteParMois[$moisAnnee] = array("Prix par mois" => 0, "Surface par mois" => 0);
            }

            $prixVenteParMois[$moisAnnee]["Prix par mois"   ] += $donnee->getValeurFonciere();
            $prixVenteParMois[$moisAnnee]["Surface par mois"] += $donnee->getSurface();
        }

        $listeReponse = array();
        foreach ($prixVenteParMois as $key => $prixvente) {
            $listeReponse[$key] = $prixvente["Prix par mois"] / $prixvente["Surface par mois"];
        }

        return new JsonResponse(array("data"=>$listeReponse));
    }
}
