<?php
namespace App\Tests;

use ApiPlatform\Core\Bridge\Symfony\Bundle\Test\ApiTestCase;
use App\Entity\Donnee;

class DonneesTest extends ApiTestCase
{
    public function testGetCollection(): void {
        $client = static::createClient();

        $response = $client->request('GET', '/donnees');
        $this->assertResponseIsSuccessful();
        $this->assertResponseHeaderSame('content-type', 'application/ld+json; charset=utf-8');
    }

    public function testGetNombreVentes(): void {
        $client = static::createClient();

        $response = $client->request('GET', '/nombre-ventes/year/01-01-2015/12-31-2020');
        $this->assertResponseIsSuccessful();
    }

    public function testGetPrixM2(): void {
        $client = static::createClient();

        $response = $client->request('GET', '/prix-m2');
        $this->assertResponseIsSuccessful();
    }

    public function testGetRepartitionVentes(): void {
        $client = static::createClient();

        $response = $client->request('GET', '/repartition-ventes/2015');
        $this->assertResponseIsSuccessful();
    }



}
