import React from 'react';
import '../../css/style.css';
import * as d3 from "d3";
import App from "./App";

class Repartitionventes extends React.Component {

  constructor(props){
    super(props);

    this.state = {
      data: [],
      year : 2015
    }
    this.handleChange = this.handleChange.bind(this);
  }

  handleChange(event) {
    this.setState({year: event.target.value}, this.getData);
  }

  getData(){
    d3.select("#graph").html("Chargement ...");
    fetch(`https://${document.domain}:8443/repartition-ventes/${this.state.year}`)
      .then(response => {
        if (response.ok) {
          return response.json();
        } else {
          throw new Error('error');
        }
      })
      .then(data => {
        this.setState({data: data });
        this.drawPieChart();
      })
      .catch(error => console.log("error"));
  }

  componentDidMount(){
    this.getData();
  }

  drawPieChart(){
    const data = this.state.data;

    const width = 1000;
    const margin = 300;
    const heightFooter = 100;
    const height = width-margin*2+heightFooter;

    const radius = Math.min(width, width) / 2 - margin;

    const svg = d3.select("#graph").html("")
      .append("svg")
      .attr("id", "chart")
      .attr("width", width)
      .attr("height", height)
      .append("g")
      .attr("transform", "translate(" + width / 2 + "," + (height-heightFooter) / 2 + ")");

    const color = d3.scaleOrdinal()
      .domain(Object.keys(data))
      .range(d3.schemeCategory10);

    const pie = d3.pie()
      .sort(null)
      .value(function(d) {return d.value; });

    const dataLabel = [];
    for( const key in data)
      dataLabel.push( {"key":key,"value":data[key]});

    const data_ready = pie(dataLabel);

    const arc = d3.arc()
      .innerRadius(radius * 0.5)
      .outerRadius(radius * 0.8);

    const outerArc = d3.arc()
      .innerRadius(radius * 0.9)
      .outerRadius(radius * 0.9);

    svg
      .selectAll('allSlices')
      .data(data_ready)
      .enter()
      .append('path')
      .attr('d', arc)
      .attr('fill', function(d){ return(color(d.data.key)) })
      .attr("stroke", "white")
      .style("stroke-width", "2px")
      .style("opacity", 0.7);

    svg
      .selectAll('allPolylines')
      .data(data_ready)
      .enter()
      .append('polyline')
      .attr("stroke", "black")
      .style("fill", "none")
      .attr("stroke-width", 1)
      .attr('points', function(d) {
        const posA = arc.centroid(d)
        const posB = outerArc.centroid(d)
        const posC = outerArc.centroid(d);
        const midangle = d.startAngle + (d.endAngle - d.startAngle) / 2
        posC[0] = radius * 0.95 * (midangle < Math.PI ? 1 : -1);
        return [posA, posB, posC]
      });

    svg
      .selectAll('allLabels')
      .data(data_ready)
      .enter()
      .append('text')
      .text( function(d) {
        var midangle = d.startAngle + (d.endAngle - d.startAngle) / 2
        return (midangle >= Math.PI ? d.data.key + ' : ' + d.data.value.toFixed(2) +'%': d.data.value.toFixed(2) + '% : ' + d.data.key)
      })
      .attr('transform', function(d) {
        const pos = outerArc.centroid(d);
        const midangle = d.startAngle + (d.endAngle - d.startAngle) / 2
        pos[0] = radius * 0.99 * (midangle < Math.PI ? 1 : -1);
        return 'translate(' + pos + ')';
      })
      .style('text-anchor', function(d) {
        const midangle = d.startAngle + (d.endAngle - d.startAngle) / 2
        return (midangle < Math.PI ? 'start' : 'end')
      });

    svg
      .append('text')
      .attr('transform',"translate(" + 0 + "," + (height/ 2)+ ")")
      .attr("text-anchor", "middle")
      .style("font-size", "16px")
      .style("text-decoration", "underline")
      .text("Diagramme circulaire de la répartition des ventes pour " + this.state.year + " par régions");
  }

  render(){
    return (
      <div>
      <App/>
        <div id="content">
          <h1>Répartition des ventes en {this.state.year}</h1>
          <select value={this.state.year} onChange={this.handleChange}>
            <option value="2015">2015</option>
            <option value="2016">2016</option>
            <option value="2017">2017</option>
            <option value="2018">2018</option>
            <option value="2019">2019</option>
            <option value="2020">2020</option>
          </select>
          <div id="graph"></div>
        </div>
      </div>
    );
  }
}

export default Repartitionventes;



