<?php
// api/src/Entity/Donnes.php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Annotation\ApiResource;
use App\Controller\DonneeM2Controller;
use App\Controller\DonneeNbVentesController;
use App\Controller\DonneePourcentRegionController;

/**
 * Une donnée.
 * @ApiResource(
 *     collectionOperations={
 *          "get",
 *          "donneem2"={
 *              "method"="GET",
 *              "read"=false,
 *              "openapi_context" = {
 *                  "summary" = "Test",
 *                  "read"=false
 *              },
 *              "path"="/prix-m2",
 *              "controller"=DonneeM2Controller::class,
 *              "pagination_enabled"=false
 *          },
 *          "donneenbventes"={
 *              "method"="GET",
 *              "read"=false,
 *              "openapi_context" = {
 *                      "summary" = "Test",
 *                      "read"=false,
 *                      "parameters" = {
 *                        {
 *                          "name" = "unit",
 *                          "in" = "path",
 *                          "required" = "true",
 *                          "type" = "string"
 *                      },
 *                       {
 *                          "name" = "start",
 *                          "in" = "path",
 *                          "required" = "true",
 *                          "type" = "string"
 *                       },
 *                       {
 *                          "name" = "end",
 *                          "in" = "path",
 *                          "required" = "true",
 *                          "type" = "string"
 *                      }
 *                      }
 *               },
 *              "path"="/nombre-ventes/{unit}/{start}/{end}",
 *              "controller"=DonneeNbVentesController::class,
 *              "pagination_enabled"=false,
 *          },
 *          "donneepxregion"={
 *              "method"="GET",
 *              "read"=false,
 *              "openapi_context" = {
 *                      "summary" = "Test",
 *                      "read"=false,
 *                      "parameters" = {
 *                       {
 *                          "name" = "year",
 *                          "in" = "path",
 *                          "required" = "true",
 *                          "type" = "string"
 *                       }
 *                      }
 *               },
 *              "path"="/repartition-ventes/{year}",
 *              "controller"=DonneePourcentRegionController::class,
 *              "pagination_enabled"=false,
 *          }
 *     },
 *     itemOperations={"get"}
 * )
 * @ORM\Entity
 */
class Donnee
{
    /**
     * @var int L'id de la donnée
     *
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var \DateTime Date de la mutation.
     *
     * @ORM\Column(type="datetime")
     */
    public $dateMutation;

    /**
     * @var string Type de la mutation.
     *
     * @ORM\Column
     */
    public $typeMutation;

    /**
     * @var string Region.
     *
     * @ORM\Column
     */
    public $region;

    /**
     * @var double Valeur fonciere.
     *
     * @ORM\Column(type="float")
     */
    public $valeurFonciere;

    /**
     * @var string Code du departement.
     *
     * @ORM\Column
     */
    public $codeDpt;

    /**
     * @var string Type local.
     *
     * @ORM\Column
     */
    public $typeLocal;

    /**
     * @var double Surface reele batie.
     *
     * @ORM\Column(type="float")
     */
    public $surface;

    /**
     * @return \DateTime
     */
    public function getDateMutation(): \DateTime
    {
        return $this->dateMutation;
    }

    /**
     * @param \DateTime $dateMutation
     */
    public function setDateMutation(\DateTime $dateMutation): void
    {
        $this->dateMutation = $dateMutation;
    }

    /**
     * @return string
     */
    public function getTypeMutation(): string
    {
        return $this->typeMutation;
    }

    /**
     * @param string $typeMutation
     */
    public function setTypeMutation(string $typeMutation): void
    {
        $this->typeMutation = $typeMutation;
    }

    /**
     * @return float
     */
    public function getValeurFonciere(): float
    {
        return $this->valeurFonciere;
    }

    /**
     * @param float $valeurFonciere
     */
    public function setValeurFonciere(float $valeurFonciere): void
    {
        $this->valeurFonciere = $valeurFonciere;
    }

    /**
     * @return string
     */
    public function getCodeDpt(): string
    {
        return $this->codeDpt;
    }

    /**
     * @param string $codeDpt
     */
    public function setCodeDpt(string $codeDpt): void
    {
        $this->codeDpt = $codeDpt;
    }

    /**
     * @return string
     */
    public function getTypeLocal(): string
    {
        return $this->typeLocal;
    }

    /**
     * @param string $typeLocal
     */
    public function setTypeLocal(string $typeLocal): void
    {
        $this->typeLocal = $typeLocal;
    }

    /**
     * @return float
     */
    public function getSurface(): float
    {
        return $this->surface;
    }

    /**
     * @param float $surface
     */
    public function setSurface(float $surface): void
    {
        $this->surface = $surface;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setRegion(string $region): void
    {
        $this->region = $region;
    }

    public function getRegion(): string
    {
        return $this->region;
    }
}
