<?php
namespace App\Controller;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

use App\Entity\Donnee;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class DonneeNbVentesController
{
    private $em;

    public function __construct(EntityManagerInterface $em) {
        $this->em = $em;
    }

    public function __invoke(Request $data, string $unit, string $start, string $end)
    {

        $query = "  SELECT
                        COUNT(data.typeMutation) AS nombre_de_vente,
                        DATE_TRUNC('$unit', data.dateMutation) AS unit
                    FROM App:Donnee AS data
                    WHERE data.dateMutation BETWEEN '$start'  AND '$end'
                    GROUP BY unit
                    ORDER BY unit";

        $resQuery = $this->em->createQuery($query)->getResult();


        foreach ($resQuery as &$nbVente) {
            $nbVente['nombre_de_vente'] = intval($nbVente['nombre_de_vente']);
            switch ($unit) {
                case 'year':
                    $nbVente['unit'] = substr($nbVente['unit'], 0, 4);
                    break;
                case 'month':
                    $nbVente['unit'] = substr($nbVente['unit'], 5, 2).'/'.substr($nbVente['unit'], 0, 4);
                    break;
                case 'day':
                    $nbVente['unit'] = substr($nbVente['unit'], 8, 2).'/'.substr($nbVente['unit'], 5, 2)
                        .'/'.substr($nbVente['unit'], 0, 4);
                    break;
            }
        }

        return new JsonResponse($resQuery);
    }
}
