import React from 'react';
import '../../css/style.css';
import App from "./App";
import * as d3 from "d3";

class PrixM2 extends React.Component {

  constructor(props){
    super(props);
    this.state = {
      data: []
    }
  }

  getData(){
    fetch(`https://${document.domain}:8443/prix-m2`)
      .then(response => {
        if (response.ok) {
          return response.json();
        } else {
          throw new Error('error2');
        }
      })
      .then(data => {
        this.setState({data: data });
        this.drawLineChart();
      })
      .catch(error => console.log("error"));
  }

  componentDidMount(){
    this.getData();
  }

  drawLineChart() {
    const data =  this.state.data
    console.log(data)

    const margin = {top: 20, right: 30, bottom: 30, left: 60};
    const width = 800 - margin.left - margin.right;
    const height = 400 - margin.top - margin.bottom;

    const parseTime = d3.timeParse("%Y-%m-%d %H:%M:%S");

    const x = d3.scaleTime()
      .range([0, width]);

    const y = d3.scaleLinear()
      .range([height, 0]);

    console.log(data)
    const line = d3.line()
      .x(d => x(d.month))
      .y(d => y(d.moyenne_surface));

    const svg = d3.select("#chart").html("")
      .append("svg")
      .attr("id", "svg")
      .attr("width", width + margin.left + margin.right)
      .attr("height", height + margin.top + margin.bottom)
      .append("g")
      .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

    var map = {};
    data.forEach(function(d) {
      d.month = parseTime(d.month);
      d.moyenne_surface = +d.moyenne_surface;
    });

    x.domain(d3.extent(data, d => d.month ));
    y.domain(d3.extent(data, d => d.moyenne_surface))

    svg.append("g")
      .attr("transform", "translate(0," + height + ")")
      .call(d3.axisBottom(x));

    svg.append("g")
      .call(d3.axisLeft(y))
      .append("text")
      .attr("fill", "#000")
      .attr("transform", "rotate(-90)")
      .attr("y", 6)
      .attr("dy", "0.71em")
      .style("text-anchor", "end")
      .text("Pts");

    svg.selectAll("y axis").data(y.ticks(10)).enter()
      .append("line")
      .attr("class", "horizontalGrid")
      .attr("x1", 0)
      .attr("x2", width)
      .attr("y1", d => y(d))
      .attr("y2", d => y(d));

    svg.append("path")
      .datum(data)
      .attr("class", "line")
      .attr("d", line)
      .attr("stroke", "#123")
      .style("fill","none");
  }

  render() {
    return  (
      <div>
        <App/>
        <h2>Série temporelle</h2>
        <div id="chart">
          Chargement...
        </div>
      </div>
    )
  }
}

export default PrixM2;
