import React from 'react';
import '../../css/style.css';
import App from "./App";

class Nombreventes extends React.Component {

  type = {
    ANNEE: 'annees',
    MOIS: 'mois',
    JOURS: 'jours'
  }

  constructor(props){
    super(props);

    this.state = {
      data: [],
      type: this.type.ANNEE,
      startDate : '03-05-2015',
      endDate: '03-05-2020'
    }
  }

  getData(){
    console.log(`https://${document.domain}:8443/nombre-ventes/${this.state.type}/${this.state.startDate}/${this.state.endDate}`)
    fetch(`https://${document.domain}:8443/nombre-ventes/${this.state.type}/${this.state.startDate}/${this.state.endDate}`)
      .then(response => {
        if (response.ok) {
          return response.json();
        } else {
          throw new Error('error');
        }
      })
      .then(data => {
        this.setState({data: data });
      })
      .catch(error => console.log("error"));
  }

  componentDidMount(){
    this.getData();
  }

  render() {
    console.log(this.state.data)
    return  (
      <div>
        <App/>
        Nombreventes
      </div>
    )
  }
}

export default Nombreventes;


