<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;
use App\Entity\Donnee;

class AppFixtures extends Fixture
{
    public $dptByRegion = array(
        "Auvergne-Rhône-Alpes" => ["03", "63", "15", "42", "43", "69", "07", "01", "26", "38", "73", "74"],
        "Bourgogne-Franche-Comté" => ["89", "21", "70", "58", "71", "39", "25", "90"],
        "Bretagne" => ["29", "22", "56", "35"],
        "Centre-Val de Loire" => ["28", "41", "37", "45", "36", "18"],
        "Corse" => ["2B", "2A"],
        "Grand Est" => ["08", "51", "10", "55", "52", "54", "57", "88", "67", "68"],
        "Hauts-de-France" => ["62", "59", "80", "02", "60"],
        "Île-de-France" => ["78", "95", "91", "77","92","75","93","94"],
        "Normandie" => ["76", "27", "61", "14", "50"],
        "Nouvelle-Aquitaine" => ["79", "17", "33", "40", "64", "86", "16", "24", "47", "87", "19", "23"],
        "Occitanie" => ["46", "82", "32", "65", "12", "81", "31", "09", "48", "30", "34", "11", "66"],
        "Pays de la Loire" => ["53", "72", "44", "49", "85"],
        "Provence-Alpes-Côte d’Azur" => ["05", "04", "06", "84", "13", "83"],
        "Outre-mer" => ["971", "972", "973", "974", "976"]
    );

    public function load(ObjectManager $manager)
    {
        $fichiers = ["valeursfoncieres-2015-s2.txt", "valeursfoncieres-2016.txt", "valeursfoncieres-2017.txt",
            "valeursfoncieres-2018.txt", "valeursfoncieres-2019.txt",  "valeursfoncieres-2020.txt"];
        $typeLocals = ["Appartement", "Maison"];
        $manager->getConnection()->getConfiguration()->setSQLLogger(null);
        foreach ($fichiers as $fichier) {
            $file = fopen("data/" . $fichier, 'r');
            $line = fgets($file);
            $line = fgets($file);
            while($line != false){
                $split = explode("|", $line);
                if (in_array($split[36], $typeLocals) && strcmp($split[9], "Vente") == 0) {
                    $donnee = new Donnee();

                    $date = date_create_from_format("j/m/Y", $split[8]);

                    $donnee->setDateMutation($date);
                    $donnee->setTypeMutation($split[9]);
                    $donnee->setValeurFonciere(floatval(str_replace(",", ".", $split[10])));
                    $donnee->setCodeDpt($split[18]);
                    $donnee->setRegion($this->getRegionByDpt($split[18]));
                    $donnee->setTypeLocal($split[36]);
                    $donnee->setSurface(intval($split[38]));
                    $manager->persist($donnee);

                    $manager->flush();
                    $manager->clear();
                }
                $line = fgets($file);
            }
            fclose($file);
        }
    }

    private function getRegionByDpt(string $codeDpt): string
    {
        foreach ($this->dptByRegion as $region => $dpts) {
            if(in_array($codeDpt, $dpts)) {
                return $region;
            }
        }
    }
}
