<?php

namespace App\Controller;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;


class DonneePourcentRegionController extends AbstractController
{
    private $em;

    public function __construct(EntityManagerInterface $em) {
        $this->em = $em;
    }

    public function __invoke(Request $data, string $year)
    {
        $year = $year.'-01-01';
        $query = "  SELECT
                        COUNT(data.typeMutation) AS nombre_de_vente,
                        data.region AS region
                    FROM App:Donnee AS data
                    WHERE DATE_TRUNC('year', data.dateMutation) = '$year'
                    GROUP BY region
                    ORDER BY region";

        $resQuery = $this->em->createQuery($query)->getResult();

        $nbVentesRegion = array();
        foreach ($resQuery as $donnee) {
            $nbVentesRegion[$donnee['region']] = intval($donnee['nombre_de_vente']);
        }

        $listeReponse = array();
        foreach ($nbVentesRegion as $key => $nbVente) {
            $listeReponse[$key] = ($nbVente / array_sum($nbVentesRegion)) * 100;
        }

        return new JsonResponse($listeReponse);
    }
}
