package unlh.graph.algo;

import org.graphstream.algorithm.generator.RandomGenerator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;

public class ShortestPath {
    public static void main(String argvs[]) throws Exception {
        Graph graph = new SingleGraph("ShortestPath");
        RandomGenerator gen = new RandomGenerator(6, false, true); // creation d'un générateur
        long debut, fin, total; // temps de debut et fin

        gen.setEdgeAttributesRange(10.0, 50.0); // definition de l'attribut des arcs depuis un range[10.0, 50.0]
        gen.addEdgeAttribute("cap"); // attribution des valeurs vers un attribut nommé "cap"
        gen.addSink(graph);
        gen.begin();
        // génération de 10000 noeuds
        for (int i = 0; i < 30000; i++)
            gen.nextEvents();
        gen.end();

        Dijkstra naiveDjikistra = new Dijkstra(graph, graph.getNode(0));
        // on choisit le premier noeud comme source
        //
        debut = System.currentTimeMillis();
        naiveDjikistra.compute();
        fin = System.currentTimeMillis();
        total = fin - debut;

        System.out.println("Execution time : " + total + " ms");
        for (Edge e : graph.getEachEdge()) {
            Double rounded = Double.valueOf(Math.round(Double.parseDouble(e.getAttribute("cap").toString())));
            e.addAttribute("ui.style", "shape:circle;fill-color: black;size: 1px; text-alignment: center;");
            e.setAttribute("ui.label", rounded.toString());
        }
        for (Node n : graph.getEachNode()) {
            n.setAttribute("ui.label", n.getId());
        }

        graph.display();
    }
}