package unlh.graph.algo;

import org.graphstream.algorithm.generator.RandomGenerator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class DijkstraTest {
    RandomGenerator gen;
    Graph graph;
    Dijkstra dijkstra;
    Node source;

    @BeforeEach
    void setUp() {
        graph = new SingleGraph("Test");
        gen = new RandomGenerator(4, false, true); // creation d'un générateur
        gen.setEdgeAttributesRange(10.0, 50.0); // definition de l'attribut des arcs depuis un range[10.0, 50.0]
        gen.addEdgeAttribute("cap"); // attribution des valeurs vers un attribut nommé "cap"
        gen.addSink(graph);
        gen.begin();
        for (int i = 0; i < 100; i++) // test sur 100 noeuds
            gen.nextEvents();
        gen.end();
        source = graph.nodeFactory().newInstance("S", graph);
        dijkstra = new Dijkstra(graph, source);
    }

    @Test
    void init() {
        assertNotNull(dijkstra.graph, "Graph is null");
        assertNotNull(dijkstra.source, "Source is null");
        assertNotNull(dijkstra.queue, "queue is null");
    }

    @Test
    void compute() {
        assertNotNull(dijkstra.getGraph(), "No graph to compute shortest path");
        assertNotNull(dijkstra.getSource(), "No source node");
        assertTrue(dijkstra.isQueueEmpty(), "Queue not empty, check your algorithm"); // la fin de l'algorithme doit vider la file prioritaire
    }

    @Test
    void getGraph() {
        assertTrue(dijkstra.getGraph().equals(graph), "Graph is Null or was updated!");
        assertNotNull(dijkstra.getGraph(), "Graph is null");
    }

    @Test
    void setGraph() {
        assertNotNull(dijkstra.getGraph(), "Graph attribute is null");
        assertTrue(dijkstra.getGraph().equals(graph), "Graph attribute was updated");
    }

    @Test
    void getSource() {
        assertTrue(dijkstra.getSource().equals(source), "Source is Null or was updated!");
        assertNotNull(dijkstra.getSource(), "Source is empty");
    }

    @Test
    void setSource() {
        dijkstra.setSource(source); // setting source to null to test
        assertNotNull(dijkstra.getSource(), "Source still null");
    }
}